#include "mex.h"
#include "matrix.h"
#include "math.h"
#include "stdio.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )

{

    /* -- Inputs -- */
	double *nin			= mxGetPr(prhs[0]);
	double *nxin		= mxGetPr(prhs[1]);
	double *nyin		= mxGetPr(prhs[2]);
	double *nein		= mxGetPr(prhs[3]);
    double *xss 		= mxGetPr(prhs[4]);
    double *yss 		= mxGetPr(prhs[5]);
	double *parmin 		= mxGetPr(prhs[6]);
	double *nnuin 		= mxGetPr(prhs[7]);
	double *sigsin  	= mxGetPr(prhs[8]);
	double *Hs  		= mxGetPr(prhs[9]);
	double *Gs 			= mxGetPr(prhs[10]);
	double *Gsp 		= mxGetPr(prhs[11]);
	double *G2sp 		= mxGetPr(prhs[12]);
	double *Psspin  	= mxGetPr(prhs[13]);
	double *dP1sspin	= mxGetPr(prhs[14]);
	double *dP2sspin	= mxGetPr(prhs[15]);


	/* -- Specific Inputs -- */
	int n 				= nin[0];
	int nx 				= nxin[0];
	int ny 				= nyin[0];
	int ne 				= nein[0];
	double nnus 		= nnuin[0];
	double bbeta 		= parmin[0];
	double rrho 		= parmin[1];
	double oomega 		= parmin[2];
	double eeta 		= parmin[3];
	double aalpha 		= parmin[4];
	double ddelta 		= parmin[5];
	double pbar 		= parmin[6];
	double ebar 		= parmin[7];
	double iiota 		= parmin[8];
	double pphi 		= parmin[9];
	double rbar 		= parmin[10];
	double kkappa   	= parmin[11];
	double rrhoa 		= parmin[12];
	double rrhoz 		= parmin[13];
	double rrhop 		= parmin[14];
	double rrhor 		= parmin[15];
	double rrhoe 		= parmin[16];
	double rrhod 	 	= parmin[17];
	double varphibar 	= parmin[18];
	double bbar 		= parmin[19];
	double ppsir 		= parmin[20];
	double abar  		= parmin[21];
	double zbar 		= parmin[22];
	double ssigmaas		= sigsin[0];
	double ssigmazs		= sigsin[1];
	double ssigmaps		= sigsin[2];
	double ssigmars		= sigsin[3];
	double ssigmaes		= sigsin[4];
	double ssigmads		= sigsin[5];
	double Pssp 		= Psspin[0];
	double dP1ssp 		= dP1sspin[0];
	double dP2ssp 		= dP2sspin[0];

	/* -- Outputs -- */
	plhs[0] = mxCreateDoubleMatrix(n*nx*ne,(n+ny)*nx*ne,mxREAL);
	plhs[1] = mxCreateDoubleMatrix(n*nx*ne,1,mxREAL);
	double *Mxe_sp_s = mxGetPr(plhs[0]);
	double *Nxe_sp_s = mxGetPr(plhs[1]);

    /* -- Definition of Variables -- */
    double E = 2.71828182845905;


    /* -- Mathematica Output Here -- */
    Mxe_sp_s[8064]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[442368]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[443520]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[451584]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[452736]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[453888]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[2305]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[3457]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[4609]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[443521]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[444673]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[448129]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[451585]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[452737]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[453889]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[2306]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[3458]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[443522]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[444674]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[448130]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[450434]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[451586]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[452738]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[453890]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[3]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1155]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[2307]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[3459]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[4611]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[5763]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[6915]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[8067]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[448131]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[451587]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[452739]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[453891]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[4]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[1156]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[2308]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[3460]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[4612]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[5764]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[6916]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[8068]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[449284]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[451588]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[452740]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[453892]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[5]=iiota*Pssp*zbar;
	Mxe_sp_s[3461]=iiota*Pssp*zbar;
	Mxe_sp_s[449285]=-Pssp;
	Mxe_sp_s[443526]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[450438]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[452742]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[453894]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1159]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[2311]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[3463]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[4615]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[6919]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[442375]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[443527]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[444679]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[445831]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[448135]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[450439]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[452743]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[453895]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[8]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[3464]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[445832]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[452744]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[453896]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[9]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1161]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[3465]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[4617]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[443529]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[444681]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[448137]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[449289]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[450441]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[452745]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[453897]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[452746]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[453898]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1163]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[5771]=Pssp;
	Mxe_sp_s[448139]=-Pssp;
	Mxe_sp_s[452747]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[453899]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[12]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[446988]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[2317]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[3469]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[4621]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[443533]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[444685]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[452749]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[453901]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[455053]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[1166]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[3470]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[452750]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[453902]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[455054]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[456206]=Pssp;
	Mxe_sp_s[1167]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[3471]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[452751]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[453903]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[455055]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[457359]=Pssp;
	Mxe_sp_s[6928]=ebar*Pssp;
	Mxe_sp_s[442384]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[445840]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[452752]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[453904]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[455056]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[458512]=Pssp;
	Mxe_sp_s[17]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1169]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[2321]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[3473]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[4625]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[5777]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[6929]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[8081]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[452753]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[453905]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[459665]=Pssp;
	Mxe_sp_s[2322]=-Pssp;
	Mxe_sp_s[3475]=-Pssp;
	Mxe_sp_s[4628]=-Pssp;
	Mxe_sp_s[8085]=-Pssp;
	Mxe_sp_s[6934]=-Pssp;
	Mxe_sp_s[5783]=-Pssp;
	Mxe_sp_s[17304]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[460824]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[461976]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[470040]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[471192]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[472344]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[11545]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[12697]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[13849]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[461977]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[463129]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[466585]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[470041]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[471193]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[472345]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[11546]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[12698]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[461978]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[463130]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[466586]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[468890]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[470042]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[471194]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[472346]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[9243]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[10395]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[11547]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[12699]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[13851]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[15003]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[16155]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[17307]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[466587]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[470043]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[471195]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[472347]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[9244]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[10396]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[11548]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[12700]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[13852]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[15004]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[16156]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[17308]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[467740]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[470044]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[471196]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[472348]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[9245]=iiota*Pssp*zbar;
	Mxe_sp_s[12701]=iiota*Pssp*zbar;
	Mxe_sp_s[467741]=-Pssp;
	Mxe_sp_s[461982]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[468894]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[471198]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[472350]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[10399]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[11551]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[12703]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[13855]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[16159]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[460831]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[461983]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[463135]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[464287]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[466591]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[468895]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[471199]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[472351]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[9248]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[12704]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[464288]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[471200]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[472352]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[9249]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[10401]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[12705]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[13857]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[461985]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[463137]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[466593]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[467745]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[468897]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[471201]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[472353]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[471202]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[472354]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[10403]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[15011]=Pssp;
	Mxe_sp_s[466595]=-Pssp;
	Mxe_sp_s[471203]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[472355]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[9252]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[465444]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[11557]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[12709]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[13861]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[461989]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[463141]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[471205]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[472357]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[473509]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[10406]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[12710]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[471206]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[472358]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[473510]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[474662]=Pssp;
	Mxe_sp_s[10407]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[12711]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[471207]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[472359]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[473511]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[475815]=Pssp;
	Mxe_sp_s[16168]=ebar*Pssp;
	Mxe_sp_s[460840]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[464296]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[471208]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[472360]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[473512]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[476968]=Pssp;
	Mxe_sp_s[9257]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[10409]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[11561]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[12713]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[13865]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[15017]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[16169]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[17321]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[471209]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[472361]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[478121]=Pssp;
	Mxe_sp_s[11562]=-Pssp;
	Mxe_sp_s[12715]=-Pssp;
	Mxe_sp_s[13868]=-Pssp;
	Mxe_sp_s[17325]=-Pssp;
	Mxe_sp_s[16174]=-Pssp;
	Mxe_sp_s[15023]=-Pssp;
	Mxe_sp_s[26544]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[479280]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[480432]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[488496]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[489648]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[490800]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[20785]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[21937]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[23089]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[480433]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[481585]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[485041]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[488497]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[489649]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[490801]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[20786]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[21938]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[480434]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[481586]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[485042]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[487346]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[488498]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[489650]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[490802]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[18483]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[19635]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[20787]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[21939]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[23091]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[24243]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[25395]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[26547]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[485043]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[488499]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[489651]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[490803]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[18484]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[19636]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[20788]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[21940]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[23092]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[24244]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[25396]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[26548]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[486196]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[488500]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[489652]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[490804]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[18485]=iiota*Pssp*zbar;
	Mxe_sp_s[21941]=iiota*Pssp*zbar;
	Mxe_sp_s[486197]=-Pssp;
	Mxe_sp_s[480438]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[487350]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[489654]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[490806]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[19639]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[20791]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[21943]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[23095]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[25399]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[479287]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[480439]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[481591]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[482743]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[485047]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[487351]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[489655]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[490807]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[18488]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[21944]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[482744]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[489656]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[490808]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[18489]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[19641]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[21945]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[23097]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[480441]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[481593]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[485049]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[486201]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[487353]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[489657]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[490809]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[489658]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[490810]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[19643]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[24251]=Pssp;
	Mxe_sp_s[485051]=-Pssp;
	Mxe_sp_s[489659]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[490811]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[18492]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[483900]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[20797]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[21949]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[23101]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[480445]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[481597]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[489661]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[490813]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[491965]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[19646]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[21950]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[489662]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[490814]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[491966]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[493118]=Pssp;
	Mxe_sp_s[19647]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[21951]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[489663]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[490815]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[491967]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[494271]=Pssp;
	Mxe_sp_s[25408]=ebar*Pssp;
	Mxe_sp_s[479296]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[482752]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[489664]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[490816]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[491968]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[495424]=Pssp;
	Mxe_sp_s[18497]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[19649]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[20801]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[21953]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[23105]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[24257]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[25409]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[26561]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[489665]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[490817]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[496577]=Pssp;
	Mxe_sp_s[20802]=-Pssp;
	Mxe_sp_s[21955]=-Pssp;
	Mxe_sp_s[23108]=-Pssp;
	Mxe_sp_s[26565]=-Pssp;
	Mxe_sp_s[25414]=-Pssp;
	Mxe_sp_s[24263]=-Pssp;
	Mxe_sp_s[35784]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[497736]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[498888]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[506952]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[508104]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[509256]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[30025]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[31177]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[32329]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[498889]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[500041]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[503497]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[506953]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[508105]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[509257]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[30026]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[31178]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[498890]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[500042]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[503498]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[505802]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[506954]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[508106]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[509258]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[27723]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[28875]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[30027]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[31179]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[32331]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[33483]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[34635]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[35787]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[503499]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[506955]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[508107]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[509259]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[27724]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[28876]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[30028]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[31180]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[32332]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[33484]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[34636]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[35788]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[504652]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[506956]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[508108]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[509260]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[27725]=iiota*Pssp*zbar;
	Mxe_sp_s[31181]=iiota*Pssp*zbar;
	Mxe_sp_s[504653]=-Pssp;
	Mxe_sp_s[498894]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[505806]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[508110]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[509262]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[28879]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[30031]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[31183]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[32335]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[34639]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[497743]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[498895]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[500047]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[501199]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[503503]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[505807]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[508111]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[509263]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[27728]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[31184]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[501200]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[508112]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[509264]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[27729]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[28881]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[31185]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[32337]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[498897]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[500049]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[503505]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[504657]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[505809]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[508113]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[509265]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[508114]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[509266]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[28883]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[33491]=Pssp;
	Mxe_sp_s[503507]=-Pssp;
	Mxe_sp_s[508115]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[509267]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[27732]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[502356]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[30037]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[31189]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[32341]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[498901]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[500053]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[508117]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[509269]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[510421]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[28886]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[31190]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[508118]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[509270]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[510422]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[511574]=Pssp;
	Mxe_sp_s[28887]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[31191]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[508119]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[509271]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[510423]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[512727]=Pssp;
	Mxe_sp_s[34648]=ebar*Pssp;
	Mxe_sp_s[497752]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[501208]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[508120]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[509272]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[510424]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[513880]=Pssp;
	Mxe_sp_s[27737]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[28889]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[30041]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[31193]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[32345]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[33497]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[34649]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[35801]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[508121]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[509273]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[515033]=Pssp;
	Mxe_sp_s[30042]=-Pssp;
	Mxe_sp_s[31195]=-Pssp;
	Mxe_sp_s[32348]=-Pssp;
	Mxe_sp_s[35805]=-Pssp;
	Mxe_sp_s[34654]=-Pssp;
	Mxe_sp_s[33503]=-Pssp;
	Mxe_sp_s[45024]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[516192]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[517344]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[525408]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[526560]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[527712]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[39265]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[40417]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[41569]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[517345]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[518497]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[521953]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[525409]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[526561]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[527713]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[39266]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[40418]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[517346]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[518498]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[521954]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[524258]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[525410]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[526562]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[527714]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[36963]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[38115]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[39267]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[40419]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[41571]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[42723]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[43875]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[45027]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[521955]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[525411]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[526563]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[527715]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[36964]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[38116]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[39268]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[40420]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[41572]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[42724]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[43876]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[45028]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[523108]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[525412]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[526564]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[527716]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[36965]=iiota*Pssp*zbar;
	Mxe_sp_s[40421]=iiota*Pssp*zbar;
	Mxe_sp_s[523109]=-Pssp;
	Mxe_sp_s[517350]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[524262]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[526566]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[527718]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[38119]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[39271]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[40423]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[41575]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[43879]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[516199]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[517351]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[518503]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[519655]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[521959]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[524263]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[526567]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[527719]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[36968]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[40424]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[519656]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[526568]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[527720]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[36969]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[38121]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[40425]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[41577]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[517353]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[518505]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[521961]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[523113]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[524265]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[526569]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[527721]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[526570]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[527722]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[38123]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[42731]=Pssp;
	Mxe_sp_s[521963]=-Pssp;
	Mxe_sp_s[526571]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[527723]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[36972]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[520812]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[39277]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[40429]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[41581]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[517357]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[518509]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[526573]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[527725]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[528877]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[38126]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[40430]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[526574]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[527726]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[528878]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[530030]=Pssp;
	Mxe_sp_s[38127]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[40431]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[526575]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[527727]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[528879]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[531183]=Pssp;
	Mxe_sp_s[43888]=ebar*Pssp;
	Mxe_sp_s[516208]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[519664]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[526576]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[527728]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[528880]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[532336]=Pssp;
	Mxe_sp_s[36977]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[38129]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[39281]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[40433]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[41585]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[42737]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[43889]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[45041]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[526577]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[527729]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[533489]=Pssp;
	Mxe_sp_s[39282]=-Pssp;
	Mxe_sp_s[40435]=-Pssp;
	Mxe_sp_s[41588]=-Pssp;
	Mxe_sp_s[45045]=-Pssp;
	Mxe_sp_s[43894]=-Pssp;
	Mxe_sp_s[42743]=-Pssp;
	Mxe_sp_s[54264]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[534648]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[535800]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[543864]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[545016]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[546168]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[48505]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[49657]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[50809]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[535801]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[536953]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[540409]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[543865]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[545017]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[546169]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[48506]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[49658]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[535802]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[536954]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[540410]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[542714]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[543866]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[545018]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[546170]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[46203]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[47355]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[48507]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[49659]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[50811]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[51963]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[53115]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[54267]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[540411]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[543867]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[545019]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[546171]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[46204]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[47356]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[48508]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[49660]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[50812]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[51964]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[53116]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[54268]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[541564]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[543868]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[545020]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[546172]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[46205]=iiota*Pssp*zbar;
	Mxe_sp_s[49661]=iiota*Pssp*zbar;
	Mxe_sp_s[541565]=-Pssp;
	Mxe_sp_s[535806]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[542718]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[545022]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[546174]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[47359]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[48511]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[49663]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[50815]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[53119]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[534655]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[535807]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[536959]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[538111]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[540415]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[542719]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[545023]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[546175]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[46208]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[49664]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[538112]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[545024]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[546176]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[46209]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[47361]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[49665]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[50817]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[535809]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[536961]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[540417]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[541569]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[542721]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[545025]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[546177]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[545026]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[546178]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[47363]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[51971]=Pssp;
	Mxe_sp_s[540419]=-Pssp;
	Mxe_sp_s[545027]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[546179]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[46212]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[539268]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[48517]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[49669]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[50821]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[535813]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[536965]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[545029]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[546181]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[547333]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[47366]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[49670]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[545030]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[546182]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[547334]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[548486]=Pssp;
	Mxe_sp_s[47367]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[49671]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[545031]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[546183]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[547335]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[549639]=Pssp;
	Mxe_sp_s[53128]=ebar*Pssp;
	Mxe_sp_s[534664]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[538120]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[545032]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[546184]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[547336]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[550792]=Pssp;
	Mxe_sp_s[46217]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[47369]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[48521]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[49673]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[50825]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[51977]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[53129]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[54281]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[545033]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[546185]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[551945]=Pssp;
	Mxe_sp_s[48522]=-Pssp;
	Mxe_sp_s[49675]=-Pssp;
	Mxe_sp_s[50828]=-Pssp;
	Mxe_sp_s[54285]=-Pssp;
	Mxe_sp_s[53134]=-Pssp;
	Mxe_sp_s[51983]=-Pssp;
	Mxe_sp_s[63504]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[553104]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[554256]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[562320]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[563472]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[564624]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[57745]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[58897]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[60049]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[554257]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[555409]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[558865]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[562321]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[563473]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[564625]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[57746]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[58898]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[554258]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[555410]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[558866]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[561170]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[562322]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[563474]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[564626]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[55443]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[56595]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[57747]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[58899]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[60051]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[61203]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[62355]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[63507]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[558867]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[562323]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[563475]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[564627]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[55444]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[56596]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[57748]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[58900]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[60052]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[61204]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[62356]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[63508]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[560020]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[562324]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[563476]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[564628]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[55445]=iiota*Pssp*zbar;
	Mxe_sp_s[58901]=iiota*Pssp*zbar;
	Mxe_sp_s[560021]=-Pssp;
	Mxe_sp_s[554262]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[561174]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[563478]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[564630]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[56599]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[57751]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[58903]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[60055]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[62359]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[553111]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[554263]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[555415]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[556567]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[558871]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[561175]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[563479]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[564631]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[55448]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[58904]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[556568]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[563480]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[564632]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[55449]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[56601]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[58905]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[60057]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[554265]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[555417]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[558873]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[560025]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[561177]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[563481]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[564633]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[563482]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[564634]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[56603]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[61211]=Pssp;
	Mxe_sp_s[558875]=-Pssp;
	Mxe_sp_s[563483]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[564635]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[55452]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[557724]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[57757]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[58909]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[60061]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[554269]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[555421]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[563485]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[564637]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[565789]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[56606]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[58910]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[563486]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[564638]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[565790]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[566942]=Pssp;
	Mxe_sp_s[56607]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[58911]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[563487]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[564639]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[565791]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[568095]=Pssp;
	Mxe_sp_s[62368]=ebar*Pssp;
	Mxe_sp_s[553120]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[556576]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[563488]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[564640]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[565792]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[569248]=Pssp;
	Mxe_sp_s[55457]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[56609]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[57761]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[58913]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[60065]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[61217]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[62369]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[63521]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[563489]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[564641]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[570401]=Pssp;
	Mxe_sp_s[57762]=-Pssp;
	Mxe_sp_s[58915]=-Pssp;
	Mxe_sp_s[60068]=-Pssp;
	Mxe_sp_s[63525]=-Pssp;
	Mxe_sp_s[62374]=-Pssp;
	Mxe_sp_s[61223]=-Pssp;
	Mxe_sp_s[72744]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[571560]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[572712]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[580776]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[581928]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[583080]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[66985]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[68137]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[69289]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[572713]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[573865]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[577321]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[580777]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[581929]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[583081]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[66986]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[68138]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[572714]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[573866]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[577322]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[579626]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[580778]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[581930]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[583082]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[64683]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[65835]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[66987]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[68139]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[69291]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[70443]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[71595]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[72747]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[577323]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[580779]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[581931]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[583083]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[64684]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[65836]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[66988]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[68140]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[69292]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[70444]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[71596]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[72748]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[578476]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[580780]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[581932]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[583084]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[64685]=iiota*Pssp*zbar;
	Mxe_sp_s[68141]=iiota*Pssp*zbar;
	Mxe_sp_s[578477]=-Pssp;
	Mxe_sp_s[572718]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[579630]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[581934]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[583086]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[65839]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[66991]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[68143]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[69295]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[71599]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[571567]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[572719]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[573871]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[575023]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[577327]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[579631]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[581935]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[583087]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[64688]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[68144]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[575024]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[581936]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[583088]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[64689]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[65841]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[68145]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[69297]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[572721]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[573873]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[577329]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[578481]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[579633]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[581937]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[583089]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[581938]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[583090]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[65843]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[70451]=Pssp;
	Mxe_sp_s[577331]=-Pssp;
	Mxe_sp_s[581939]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[583091]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[64692]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[576180]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[66997]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[68149]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[69301]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[572725]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[573877]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[581941]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[583093]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[584245]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[65846]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[68150]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[581942]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[583094]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[584246]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[585398]=Pssp;
	Mxe_sp_s[65847]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[68151]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[581943]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[583095]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[584247]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[586551]=Pssp;
	Mxe_sp_s[71608]=ebar*Pssp;
	Mxe_sp_s[571576]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[575032]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[581944]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[583096]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[584248]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[587704]=Pssp;
	Mxe_sp_s[64697]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[65849]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[67001]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[68153]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[69305]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[70457]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[71609]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[72761]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[581945]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[583097]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[588857]=Pssp;
	Mxe_sp_s[67002]=-Pssp;
	Mxe_sp_s[68155]=-Pssp;
	Mxe_sp_s[69308]=-Pssp;
	Mxe_sp_s[72765]=-Pssp;
	Mxe_sp_s[71614]=-Pssp;
	Mxe_sp_s[70463]=-Pssp;
	Mxe_sp_s[81984]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[590016]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[591168]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[599232]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[600384]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[601536]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[76225]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[77377]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[78529]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[591169]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[592321]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[595777]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[599233]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[600385]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[601537]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[76226]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[77378]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[591170]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[592322]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[595778]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[598082]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[599234]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[600386]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[601538]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[73923]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[75075]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[76227]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[77379]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[78531]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[79683]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[80835]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[81987]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[595779]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[599235]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[600387]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[601539]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[73924]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[75076]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[76228]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[77380]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[78532]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[79684]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[80836]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[81988]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[596932]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[599236]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[600388]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[601540]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[73925]=iiota*Pssp*zbar;
	Mxe_sp_s[77381]=iiota*Pssp*zbar;
	Mxe_sp_s[596933]=-Pssp;
	Mxe_sp_s[591174]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[598086]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[600390]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[601542]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[75079]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[76231]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[77383]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[78535]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[80839]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[590023]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[591175]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[592327]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[593479]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[595783]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[598087]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[600391]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[601543]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[73928]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[77384]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[593480]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[600392]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[601544]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[73929]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[75081]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[77385]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[78537]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[591177]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[592329]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[595785]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[596937]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[598089]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[600393]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[601545]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[600394]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[601546]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[75083]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[79691]=Pssp;
	Mxe_sp_s[595787]=-Pssp;
	Mxe_sp_s[600395]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[601547]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[73932]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[594636]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[76237]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[77389]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[78541]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[591181]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[592333]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[600397]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[601549]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[602701]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[75086]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[77390]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[600398]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[601550]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[602702]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[603854]=Pssp;
	Mxe_sp_s[75087]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[77391]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[600399]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[601551]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[602703]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[605007]=Pssp;
	Mxe_sp_s[80848]=ebar*Pssp;
	Mxe_sp_s[590032]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[593488]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[600400]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[601552]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[602704]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[606160]=Pssp;
	Mxe_sp_s[73937]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[75089]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[76241]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[77393]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[78545]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[79697]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[80849]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[82001]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[600401]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[601553]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[607313]=Pssp;
	Mxe_sp_s[76242]=-Pssp;
	Mxe_sp_s[77395]=-Pssp;
	Mxe_sp_s[78548]=-Pssp;
	Mxe_sp_s[82005]=-Pssp;
	Mxe_sp_s[80854]=-Pssp;
	Mxe_sp_s[79703]=-Pssp;
	Mxe_sp_s[91224]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[608472]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[609624]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[617688]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[618840]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[619992]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[85465]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[86617]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[87769]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[609625]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[610777]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[614233]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[617689]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[618841]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[619993]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[85466]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[86618]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[609626]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[610778]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[614234]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[616538]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[617690]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[618842]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[619994]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[83163]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[84315]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[85467]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[86619]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[87771]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[88923]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[90075]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[91227]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[614235]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[617691]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[618843]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[619995]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[83164]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[84316]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[85468]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[86620]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[87772]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[88924]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[90076]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[91228]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[615388]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[617692]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[618844]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[619996]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[83165]=iiota*Pssp*zbar;
	Mxe_sp_s[86621]=iiota*Pssp*zbar;
	Mxe_sp_s[615389]=-Pssp;
	Mxe_sp_s[609630]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[616542]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[618846]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[619998]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[84319]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[85471]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[86623]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[87775]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[90079]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[608479]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[609631]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[610783]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[611935]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[614239]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[616543]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[618847]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[619999]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[83168]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[86624]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[611936]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[618848]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[620000]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[83169]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[84321]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[86625]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[87777]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[609633]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[610785]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[614241]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[615393]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[616545]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[618849]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[620001]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[618850]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[620002]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[84323]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[88931]=Pssp;
	Mxe_sp_s[614243]=-Pssp;
	Mxe_sp_s[618851]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[620003]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[83172]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[613092]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[85477]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[86629]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[87781]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[609637]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[610789]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[618853]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[620005]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[621157]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[84326]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[86630]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[618854]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[620006]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[621158]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[622310]=Pssp;
	Mxe_sp_s[84327]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[86631]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[618855]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[620007]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[621159]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[623463]=Pssp;
	Mxe_sp_s[90088]=ebar*Pssp;
	Mxe_sp_s[608488]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[611944]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[618856]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[620008]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[621160]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[624616]=Pssp;
	Mxe_sp_s[83177]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[84329]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[85481]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[86633]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[87785]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[88937]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[90089]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[91241]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[618857]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[620009]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[625769]=Pssp;
	Mxe_sp_s[85482]=-Pssp;
	Mxe_sp_s[86635]=-Pssp;
	Mxe_sp_s[87788]=-Pssp;
	Mxe_sp_s[91245]=-Pssp;
	Mxe_sp_s[90094]=-Pssp;
	Mxe_sp_s[88943]=-Pssp;
	Mxe_sp_s[100464]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[626928]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[628080]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[636144]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[637296]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[638448]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[94705]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[95857]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[97009]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[628081]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[629233]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[632689]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[636145]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[637297]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[638449]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[94706]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[95858]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[628082]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[629234]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[632690]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[634994]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[636146]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[637298]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[638450]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[92403]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[93555]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[94707]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[95859]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[97011]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[98163]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[99315]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[100467]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[632691]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[636147]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[637299]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[638451]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[92404]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[93556]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[94708]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[95860]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[97012]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[98164]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[99316]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[100468]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[633844]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[636148]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[637300]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[638452]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[92405]=iiota*Pssp*zbar;
	Mxe_sp_s[95861]=iiota*Pssp*zbar;
	Mxe_sp_s[633845]=-Pssp;
	Mxe_sp_s[628086]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[634998]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[637302]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[638454]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[93559]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[94711]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[95863]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[97015]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[99319]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[626935]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[628087]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[629239]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[630391]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[632695]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[634999]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[637303]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[638455]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[92408]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[95864]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[630392]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[637304]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[638456]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[92409]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[93561]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[95865]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[97017]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[628089]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[629241]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[632697]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[633849]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[635001]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[637305]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[638457]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[637306]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[638458]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[93563]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[98171]=Pssp;
	Mxe_sp_s[632699]=-Pssp;
	Mxe_sp_s[637307]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[638459]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[92412]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[631548]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[94717]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[95869]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[97021]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[628093]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[629245]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[637309]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[638461]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[639613]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[93566]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[95870]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[637310]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[638462]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[639614]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[640766]=Pssp;
	Mxe_sp_s[93567]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[95871]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[637311]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[638463]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[639615]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[641919]=Pssp;
	Mxe_sp_s[99328]=ebar*Pssp;
	Mxe_sp_s[626944]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[630400]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[637312]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[638464]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[639616]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[643072]=Pssp;
	Mxe_sp_s[92417]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[93569]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[94721]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[95873]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[97025]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[98177]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[99329]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[100481]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[637313]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[638465]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[644225]=Pssp;
	Mxe_sp_s[94722]=-Pssp;
	Mxe_sp_s[95875]=-Pssp;
	Mxe_sp_s[97028]=-Pssp;
	Mxe_sp_s[100485]=-Pssp;
	Mxe_sp_s[99334]=-Pssp;
	Mxe_sp_s[98183]=-Pssp;
	Mxe_sp_s[109704]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[645384]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[646536]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[654600]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[655752]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[656904]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[103945]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[105097]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[106249]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[646537]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[647689]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[651145]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[654601]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[655753]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[656905]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[103946]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[105098]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[646538]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[647690]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[651146]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[653450]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[654602]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[655754]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[656906]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[101643]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[102795]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[103947]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[105099]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[106251]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[107403]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[108555]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[109707]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[651147]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[654603]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[655755]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[656907]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[101644]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[102796]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[103948]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[105100]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[106252]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[107404]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[108556]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[109708]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[652300]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[654604]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[655756]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[656908]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[101645]=iiota*Pssp*zbar;
	Mxe_sp_s[105101]=iiota*Pssp*zbar;
	Mxe_sp_s[652301]=-Pssp;
	Mxe_sp_s[646542]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[653454]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[655758]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[656910]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[102799]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[103951]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[105103]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[106255]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[108559]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[645391]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[646543]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[647695]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[648847]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[651151]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[653455]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[655759]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[656911]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[101648]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[105104]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[648848]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[655760]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[656912]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[101649]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[102801]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[105105]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[106257]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[646545]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[647697]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[651153]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[652305]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[653457]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[655761]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[656913]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[655762]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[656914]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[102803]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[107411]=Pssp;
	Mxe_sp_s[651155]=-Pssp;
	Mxe_sp_s[655763]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[656915]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[101652]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[650004]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[103957]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[105109]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[106261]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[646549]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[647701]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[655765]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[656917]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[658069]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[102806]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[105110]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[655766]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[656918]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[658070]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[659222]=Pssp;
	Mxe_sp_s[102807]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[105111]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[655767]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[656919]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[658071]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[660375]=Pssp;
	Mxe_sp_s[108568]=ebar*Pssp;
	Mxe_sp_s[645400]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[648856]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[655768]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[656920]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[658072]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[661528]=Pssp;
	Mxe_sp_s[101657]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[102809]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[103961]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[105113]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[106265]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[107417]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[108569]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[109721]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[655769]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[656921]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[662681]=Pssp;
	Mxe_sp_s[103962]=-Pssp;
	Mxe_sp_s[105115]=-Pssp;
	Mxe_sp_s[106268]=-Pssp;
	Mxe_sp_s[109725]=-Pssp;
	Mxe_sp_s[108574]=-Pssp;
	Mxe_sp_s[107423]=-Pssp;
	Mxe_sp_s[118944]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[663840]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[664992]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[673056]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[674208]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[675360]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[113185]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[114337]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[115489]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[664993]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[666145]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[669601]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[673057]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[674209]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[675361]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[113186]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[114338]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[664994]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[666146]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[669602]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[671906]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[673058]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[674210]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[675362]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[110883]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[112035]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[113187]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[114339]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[115491]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[116643]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[117795]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[118947]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[669603]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[673059]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[674211]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[675363]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[110884]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[112036]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[113188]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[114340]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[115492]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[116644]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[117796]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[118948]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[670756]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[673060]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[674212]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[675364]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[110885]=iiota*Pssp*zbar;
	Mxe_sp_s[114341]=iiota*Pssp*zbar;
	Mxe_sp_s[670757]=-Pssp;
	Mxe_sp_s[664998]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[671910]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[674214]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[675366]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[112039]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[113191]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[114343]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[115495]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[117799]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[663847]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[664999]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[666151]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[667303]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[669607]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[671911]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[674215]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[675367]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[110888]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[114344]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[667304]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[674216]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[675368]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[110889]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[112041]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[114345]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[115497]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[665001]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[666153]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[669609]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[670761]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[671913]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[674217]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[675369]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[674218]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[675370]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[112043]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[116651]=Pssp;
	Mxe_sp_s[669611]=-Pssp;
	Mxe_sp_s[674219]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[675371]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[110892]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[668460]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[113197]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[114349]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[115501]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[665005]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[666157]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[674221]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[675373]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[676525]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[112046]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[114350]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[674222]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[675374]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[676526]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[677678]=Pssp;
	Mxe_sp_s[112047]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[114351]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[674223]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[675375]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[676527]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[678831]=Pssp;
	Mxe_sp_s[117808]=ebar*Pssp;
	Mxe_sp_s[663856]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[667312]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[674224]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[675376]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[676528]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[679984]=Pssp;
	Mxe_sp_s[110897]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[112049]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[113201]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[114353]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[115505]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[116657]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[117809]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[118961]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[674225]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[675377]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[681137]=Pssp;
	Mxe_sp_s[113202]=-Pssp;
	Mxe_sp_s[114355]=-Pssp;
	Mxe_sp_s[115508]=-Pssp;
	Mxe_sp_s[118965]=-Pssp;
	Mxe_sp_s[117814]=-Pssp;
	Mxe_sp_s[116663]=-Pssp;
	Mxe_sp_s[128184]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[682296]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[683448]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[691512]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[692664]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[693816]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[122425]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[123577]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[124729]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[683449]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[684601]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[688057]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[691513]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[692665]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[693817]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[122426]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[123578]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[683450]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[684602]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[688058]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[690362]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[691514]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[692666]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[693818]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[120123]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[121275]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[122427]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[123579]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[124731]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[125883]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[127035]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[128187]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[688059]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[691515]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[692667]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[693819]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[120124]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[121276]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[122428]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[123580]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[124732]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[125884]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[127036]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[128188]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[689212]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[691516]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[692668]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[693820]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[120125]=iiota*Pssp*zbar;
	Mxe_sp_s[123581]=iiota*Pssp*zbar;
	Mxe_sp_s[689213]=-Pssp;
	Mxe_sp_s[683454]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[690366]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[692670]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[693822]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[121279]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[122431]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[123583]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[124735]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[127039]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[682303]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[683455]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[684607]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[685759]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[688063]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[690367]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[692671]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[693823]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[120128]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[123584]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[685760]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[692672]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[693824]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[120129]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[121281]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[123585]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[124737]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[683457]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[684609]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[688065]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[689217]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[690369]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[692673]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[693825]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[692674]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[693826]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[121283]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[125891]=Pssp;
	Mxe_sp_s[688067]=-Pssp;
	Mxe_sp_s[692675]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[693827]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[120132]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[686916]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[122437]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[123589]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[124741]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[683461]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[684613]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[692677]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[693829]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[694981]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[121286]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[123590]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[692678]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[693830]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[694982]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[696134]=Pssp;
	Mxe_sp_s[121287]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[123591]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[692679]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[693831]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[694983]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[697287]=Pssp;
	Mxe_sp_s[127048]=ebar*Pssp;
	Mxe_sp_s[682312]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[685768]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[692680]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[693832]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[694984]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[698440]=Pssp;
	Mxe_sp_s[120137]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[121289]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[122441]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[123593]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[124745]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[125897]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[127049]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[128201]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[692681]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[693833]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[699593]=Pssp;
	Mxe_sp_s[122442]=-Pssp;
	Mxe_sp_s[123595]=-Pssp;
	Mxe_sp_s[124748]=-Pssp;
	Mxe_sp_s[128205]=-Pssp;
	Mxe_sp_s[127054]=-Pssp;
	Mxe_sp_s[125903]=-Pssp;
	Mxe_sp_s[137424]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[700752]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[701904]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[709968]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[711120]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[712272]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[131665]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[132817]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[133969]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[701905]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[703057]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[706513]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[709969]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[711121]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[712273]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[131666]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[132818]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[701906]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[703058]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[706514]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[708818]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[709970]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[711122]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[712274]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[129363]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[130515]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[131667]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[132819]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[133971]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[135123]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[136275]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[137427]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[706515]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[709971]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[711123]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[712275]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[129364]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[130516]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[131668]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[132820]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[133972]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[135124]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[136276]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[137428]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[707668]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[709972]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[711124]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[712276]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[129365]=iiota*Pssp*zbar;
	Mxe_sp_s[132821]=iiota*Pssp*zbar;
	Mxe_sp_s[707669]=-Pssp;
	Mxe_sp_s[701910]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[708822]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[711126]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[712278]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[130519]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[131671]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[132823]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[133975]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[136279]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[700759]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[701911]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[703063]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[704215]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[706519]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[708823]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[711127]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[712279]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[129368]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[132824]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[704216]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[711128]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[712280]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[129369]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[130521]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[132825]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[133977]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[701913]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[703065]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[706521]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[707673]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[708825]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[711129]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[712281]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[711130]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[712282]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[130523]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[135131]=Pssp;
	Mxe_sp_s[706523]=-Pssp;
	Mxe_sp_s[711131]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[712283]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[129372]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[705372]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[131677]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[132829]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[133981]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[701917]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[703069]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[711133]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[712285]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[713437]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[130526]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[132830]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[711134]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[712286]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[713438]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[714590]=Pssp;
	Mxe_sp_s[130527]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[132831]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[711135]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[712287]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[713439]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[715743]=Pssp;
	Mxe_sp_s[136288]=ebar*Pssp;
	Mxe_sp_s[700768]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[704224]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[711136]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[712288]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[713440]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[716896]=Pssp;
	Mxe_sp_s[129377]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[130529]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[131681]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[132833]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[133985]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[135137]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[136289]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[137441]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[711137]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[712289]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[718049]=Pssp;
	Mxe_sp_s[131682]=-Pssp;
	Mxe_sp_s[132835]=-Pssp;
	Mxe_sp_s[133988]=-Pssp;
	Mxe_sp_s[137445]=-Pssp;
	Mxe_sp_s[136294]=-Pssp;
	Mxe_sp_s[135143]=-Pssp;
	Mxe_sp_s[146664]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[719208]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[720360]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[728424]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[729576]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[730728]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[140905]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[142057]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[143209]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[720361]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[721513]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[724969]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[728425]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[729577]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[730729]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[140906]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[142058]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[720362]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[721514]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[724970]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[727274]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[728426]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[729578]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[730730]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[138603]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[139755]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[140907]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[142059]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[143211]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[144363]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[145515]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[146667]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[724971]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[728427]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[729579]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[730731]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[138604]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[139756]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[140908]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[142060]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[143212]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[144364]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[145516]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[146668]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[726124]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[728428]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[729580]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[730732]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[138605]=iiota*Pssp*zbar;
	Mxe_sp_s[142061]=iiota*Pssp*zbar;
	Mxe_sp_s[726125]=-Pssp;
	Mxe_sp_s[720366]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[727278]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[729582]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[730734]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[139759]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[140911]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[142063]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[143215]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[145519]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[719215]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[720367]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[721519]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[722671]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[724975]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[727279]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[729583]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[730735]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[138608]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[142064]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[722672]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[729584]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[730736]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[138609]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[139761]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[142065]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[143217]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[720369]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[721521]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[724977]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[726129]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[727281]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[729585]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[730737]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[729586]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[730738]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[139763]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[144371]=Pssp;
	Mxe_sp_s[724979]=-Pssp;
	Mxe_sp_s[729587]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[730739]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[138612]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[723828]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[140917]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[142069]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[143221]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[720373]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[721525]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[729589]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[730741]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[731893]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[139766]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[142070]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[729590]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[730742]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[731894]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[733046]=Pssp;
	Mxe_sp_s[139767]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[142071]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[729591]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[730743]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[731895]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[734199]=Pssp;
	Mxe_sp_s[145528]=ebar*Pssp;
	Mxe_sp_s[719224]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[722680]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[729592]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[730744]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[731896]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[735352]=Pssp;
	Mxe_sp_s[138617]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[139769]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[140921]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[142073]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[143225]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[144377]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[145529]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[146681]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[729593]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[730745]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[736505]=Pssp;
	Mxe_sp_s[140922]=-Pssp;
	Mxe_sp_s[142075]=-Pssp;
	Mxe_sp_s[143228]=-Pssp;
	Mxe_sp_s[146685]=-Pssp;
	Mxe_sp_s[145534]=-Pssp;
	Mxe_sp_s[144383]=-Pssp;
	Mxe_sp_s[155904]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[737664]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[738816]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[746880]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[748032]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[749184]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[150145]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[151297]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[152449]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[738817]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[739969]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[743425]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[746881]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[748033]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[749185]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[150146]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[151298]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[738818]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[739970]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[743426]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[745730]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[746882]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[748034]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[749186]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[147843]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[148995]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[150147]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[151299]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[152451]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[153603]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[154755]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[155907]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[743427]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[746883]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[748035]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[749187]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[147844]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[148996]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[150148]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[151300]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[152452]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[153604]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[154756]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[155908]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[744580]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[746884]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[748036]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[749188]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[147845]=iiota*Pssp*zbar;
	Mxe_sp_s[151301]=iiota*Pssp*zbar;
	Mxe_sp_s[744581]=-Pssp;
	Mxe_sp_s[738822]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[745734]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[748038]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[749190]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[148999]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[150151]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[151303]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[152455]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[154759]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[737671]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[738823]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[739975]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[741127]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[743431]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[745735]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[748039]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[749191]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[147848]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[151304]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[741128]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[748040]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[749192]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[147849]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[149001]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[151305]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[152457]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[738825]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[739977]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[743433]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[744585]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[745737]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[748041]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[749193]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[748042]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[749194]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[149003]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[153611]=Pssp;
	Mxe_sp_s[743435]=-Pssp;
	Mxe_sp_s[748043]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[749195]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[147852]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[742284]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[150157]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[151309]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[152461]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[738829]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[739981]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[748045]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[749197]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[750349]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[149006]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[151310]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[748046]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[749198]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[750350]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[751502]=Pssp;
	Mxe_sp_s[149007]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[151311]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[748047]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[749199]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[750351]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[752655]=Pssp;
	Mxe_sp_s[154768]=ebar*Pssp;
	Mxe_sp_s[737680]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[741136]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[748048]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[749200]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[750352]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[753808]=Pssp;
	Mxe_sp_s[147857]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[149009]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[150161]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[151313]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[152465]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[153617]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[154769]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[155921]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[748049]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[749201]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[754961]=Pssp;
	Mxe_sp_s[150162]=-Pssp;
	Mxe_sp_s[151315]=-Pssp;
	Mxe_sp_s[152468]=-Pssp;
	Mxe_sp_s[155925]=-Pssp;
	Mxe_sp_s[154774]=-Pssp;
	Mxe_sp_s[153623]=-Pssp;
	Mxe_sp_s[165144]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[756120]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[757272]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[765336]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[766488]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[767640]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[159385]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[160537]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[161689]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[757273]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[758425]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[761881]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[765337]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[766489]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[767641]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[159386]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[160538]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[757274]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[758426]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[761882]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[764186]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[765338]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[766490]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[767642]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[157083]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[158235]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[159387]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[160539]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[161691]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[162843]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[163995]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[165147]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[761883]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[765339]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[766491]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[767643]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[157084]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[158236]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[159388]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[160540]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[161692]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[162844]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[163996]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[165148]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[763036]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[765340]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[766492]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[767644]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[157085]=iiota*Pssp*zbar;
	Mxe_sp_s[160541]=iiota*Pssp*zbar;
	Mxe_sp_s[763037]=-Pssp;
	Mxe_sp_s[757278]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[764190]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[766494]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[767646]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[158239]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[159391]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[160543]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[161695]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[163999]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[756127]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[757279]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[758431]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[759583]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[761887]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[764191]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[766495]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[767647]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[157088]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[160544]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[759584]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[766496]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[767648]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[157089]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[158241]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[160545]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[161697]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[757281]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[758433]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[761889]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[763041]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[764193]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[766497]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[767649]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[766498]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[767650]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[158243]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[162851]=Pssp;
	Mxe_sp_s[761891]=-Pssp;
	Mxe_sp_s[766499]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[767651]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[157092]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[760740]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[159397]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[160549]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[161701]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[757285]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[758437]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[766501]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[767653]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[768805]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[158246]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[160550]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[766502]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[767654]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[768806]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[769958]=Pssp;
	Mxe_sp_s[158247]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[160551]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[766503]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[767655]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[768807]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[771111]=Pssp;
	Mxe_sp_s[164008]=ebar*Pssp;
	Mxe_sp_s[756136]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[759592]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[766504]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[767656]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[768808]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[772264]=Pssp;
	Mxe_sp_s[157097]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[158249]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[159401]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[160553]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[161705]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[162857]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[164009]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[165161]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[766505]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[767657]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[773417]=Pssp;
	Mxe_sp_s[159402]=-Pssp;
	Mxe_sp_s[160555]=-Pssp;
	Mxe_sp_s[161708]=-Pssp;
	Mxe_sp_s[165165]=-Pssp;
	Mxe_sp_s[164014]=-Pssp;
	Mxe_sp_s[162863]=-Pssp;
	Mxe_sp_s[174384]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[774576]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[775728]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[783792]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[784944]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[786096]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[168625]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[169777]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[170929]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[775729]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[776881]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[780337]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[783793]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[784945]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[786097]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[168626]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[169778]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[775730]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[776882]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[780338]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[782642]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[783794]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[784946]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[786098]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[166323]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[167475]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[168627]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[169779]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[170931]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[172083]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[173235]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[174387]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[780339]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[783795]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[784947]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[786099]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[166324]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[167476]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[168628]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[169780]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[170932]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[172084]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[173236]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[174388]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[781492]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[783796]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[784948]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[786100]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[166325]=iiota*Pssp*zbar;
	Mxe_sp_s[169781]=iiota*Pssp*zbar;
	Mxe_sp_s[781493]=-Pssp;
	Mxe_sp_s[775734]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[782646]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[784950]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[786102]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[167479]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[168631]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[169783]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[170935]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[173239]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[774583]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[775735]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[776887]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[778039]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[780343]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[782647]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[784951]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[786103]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[166328]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[169784]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[778040]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[784952]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[786104]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[166329]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[167481]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[169785]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[170937]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[775737]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[776889]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[780345]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[781497]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[782649]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[784953]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[786105]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[784954]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[786106]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[167483]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[172091]=Pssp;
	Mxe_sp_s[780347]=-Pssp;
	Mxe_sp_s[784955]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[786107]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[166332]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[779196]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[168637]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[169789]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[170941]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[775741]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[776893]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[784957]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[786109]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[787261]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[167486]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[169790]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[784958]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[786110]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[787262]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[788414]=Pssp;
	Mxe_sp_s[167487]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[169791]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[784959]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[786111]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[787263]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[789567]=Pssp;
	Mxe_sp_s[173248]=ebar*Pssp;
	Mxe_sp_s[774592]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[778048]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[784960]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[786112]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[787264]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[790720]=Pssp;
	Mxe_sp_s[166337]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[167489]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[168641]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[169793]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[170945]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[172097]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[173249]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[174401]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[784961]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[786113]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[791873]=Pssp;
	Mxe_sp_s[168642]=-Pssp;
	Mxe_sp_s[169795]=-Pssp;
	Mxe_sp_s[170948]=-Pssp;
	Mxe_sp_s[174405]=-Pssp;
	Mxe_sp_s[173254]=-Pssp;
	Mxe_sp_s[172103]=-Pssp;
	Mxe_sp_s[183624]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[793032]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[794184]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[802248]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[803400]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[804552]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[177865]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[179017]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[180169]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[794185]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[795337]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[798793]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[802249]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[803401]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[804553]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[177866]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[179018]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[794186]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[795338]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[798794]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[801098]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[802250]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[803402]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[804554]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[175563]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[176715]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[177867]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[179019]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[180171]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[181323]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[182475]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[183627]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[798795]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[802251]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[803403]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[804555]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[175564]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[176716]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[177868]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[179020]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[180172]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[181324]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[182476]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[183628]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[799948]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[802252]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[803404]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[804556]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[175565]=iiota*Pssp*zbar;
	Mxe_sp_s[179021]=iiota*Pssp*zbar;
	Mxe_sp_s[799949]=-Pssp;
	Mxe_sp_s[794190]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[801102]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[803406]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[804558]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[176719]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[177871]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[179023]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[180175]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[182479]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[793039]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[794191]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[795343]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[796495]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[798799]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[801103]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[803407]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[804559]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[175568]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[179024]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[796496]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[803408]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[804560]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[175569]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[176721]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[179025]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[180177]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[794193]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[795345]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[798801]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[799953]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[801105]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[803409]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[804561]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[803410]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[804562]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[176723]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[181331]=Pssp;
	Mxe_sp_s[798803]=-Pssp;
	Mxe_sp_s[803411]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[804563]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[175572]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[797652]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[177877]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[179029]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[180181]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[794197]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[795349]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[803413]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[804565]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[805717]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[176726]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[179030]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[803414]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[804566]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[805718]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[806870]=Pssp;
	Mxe_sp_s[176727]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[179031]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[803415]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[804567]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[805719]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[808023]=Pssp;
	Mxe_sp_s[182488]=ebar*Pssp;
	Mxe_sp_s[793048]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[796504]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[803416]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[804568]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[805720]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[809176]=Pssp;
	Mxe_sp_s[175577]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[176729]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[177881]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[179033]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[180185]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[181337]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[182489]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[183641]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[803417]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[804569]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[810329]=Pssp;
	Mxe_sp_s[177882]=-Pssp;
	Mxe_sp_s[179035]=-Pssp;
	Mxe_sp_s[180188]=-Pssp;
	Mxe_sp_s[183645]=-Pssp;
	Mxe_sp_s[182494]=-Pssp;
	Mxe_sp_s[181343]=-Pssp;
	Mxe_sp_s[192864]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[811488]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[812640]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[820704]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[821856]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[823008]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[187105]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[188257]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[189409]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[812641]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[813793]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[817249]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[820705]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[821857]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[823009]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[187106]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[188258]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[812642]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[813794]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[817250]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[819554]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[820706]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[821858]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[823010]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[184803]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[185955]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[187107]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[188259]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[189411]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[190563]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[191715]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[192867]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[817251]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[820707]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[821859]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[823011]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[184804]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[185956]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[187108]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[188260]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[189412]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[190564]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[191716]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[192868]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[818404]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[820708]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[821860]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[823012]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[184805]=iiota*Pssp*zbar;
	Mxe_sp_s[188261]=iiota*Pssp*zbar;
	Mxe_sp_s[818405]=-Pssp;
	Mxe_sp_s[812646]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[819558]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[821862]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[823014]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[185959]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[187111]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[188263]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[189415]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[191719]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[811495]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[812647]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[813799]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[814951]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[817255]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[819559]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[821863]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[823015]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[184808]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[188264]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[814952]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[821864]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[823016]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[184809]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[185961]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[188265]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[189417]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[812649]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[813801]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[817257]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[818409]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[819561]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[821865]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[823017]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[821866]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[823018]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[185963]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[190571]=Pssp;
	Mxe_sp_s[817259]=-Pssp;
	Mxe_sp_s[821867]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[823019]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[184812]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[816108]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[187117]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[188269]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[189421]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[812653]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[813805]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[821869]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[823021]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[824173]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[185966]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[188270]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[821870]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[823022]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[824174]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[825326]=Pssp;
	Mxe_sp_s[185967]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[188271]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[821871]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[823023]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[824175]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[826479]=Pssp;
	Mxe_sp_s[191728]=ebar*Pssp;
	Mxe_sp_s[811504]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[814960]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[821872]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[823024]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[824176]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[827632]=Pssp;
	Mxe_sp_s[184817]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[185969]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[187121]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[188273]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[189425]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[190577]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[191729]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[192881]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[821873]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[823025]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[828785]=Pssp;
	Mxe_sp_s[187122]=-Pssp;
	Mxe_sp_s[188275]=-Pssp;
	Mxe_sp_s[189428]=-Pssp;
	Mxe_sp_s[192885]=-Pssp;
	Mxe_sp_s[191734]=-Pssp;
	Mxe_sp_s[190583]=-Pssp;
	Mxe_sp_s[202104]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[829944]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[831096]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[839160]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[840312]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[841464]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[196345]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[197497]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[198649]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[831097]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[832249]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[835705]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[839161]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[840313]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[841465]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[196346]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[197498]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[831098]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[832250]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[835706]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[838010]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[839162]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[840314]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[841466]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[194043]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[195195]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[196347]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[197499]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[198651]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[199803]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[200955]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[202107]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[835707]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[839163]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[840315]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[841467]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[194044]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[195196]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[196348]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[197500]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[198652]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[199804]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[200956]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[202108]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[836860]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[839164]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[840316]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[841468]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[194045]=iiota*Pssp*zbar;
	Mxe_sp_s[197501]=iiota*Pssp*zbar;
	Mxe_sp_s[836861]=-Pssp;
	Mxe_sp_s[831102]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[838014]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[840318]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[841470]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[195199]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[196351]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[197503]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[198655]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[200959]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[829951]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[831103]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[832255]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[833407]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[835711]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[838015]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[840319]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[841471]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[194048]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[197504]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[833408]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[840320]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[841472]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[194049]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[195201]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[197505]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[198657]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[831105]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[832257]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[835713]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[836865]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[838017]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[840321]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[841473]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[840322]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[841474]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[195203]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[199811]=Pssp;
	Mxe_sp_s[835715]=-Pssp;
	Mxe_sp_s[840323]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[841475]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[194052]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[834564]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[196357]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[197509]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[198661]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[831109]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[832261]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[840325]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[841477]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[842629]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[195206]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[197510]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[840326]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[841478]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[842630]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[843782]=Pssp;
	Mxe_sp_s[195207]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[197511]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[840327]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[841479]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[842631]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[844935]=Pssp;
	Mxe_sp_s[200968]=ebar*Pssp;
	Mxe_sp_s[829960]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[833416]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[840328]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[841480]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[842632]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[846088]=Pssp;
	Mxe_sp_s[194057]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[195209]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[196361]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[197513]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[198665]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[199817]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[200969]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[202121]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[840329]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[841481]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[847241]=Pssp;
	Mxe_sp_s[196362]=-Pssp;
	Mxe_sp_s[197515]=-Pssp;
	Mxe_sp_s[198668]=-Pssp;
	Mxe_sp_s[202125]=-Pssp;
	Mxe_sp_s[200974]=-Pssp;
	Mxe_sp_s[199823]=-Pssp;
	Mxe_sp_s[211344]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[848400]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[849552]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[857616]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[858768]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[859920]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[205585]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[206737]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[207889]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[849553]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[850705]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[854161]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[857617]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[858769]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[859921]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[205586]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[206738]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[849554]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[850706]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[854162]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[856466]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[857618]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[858770]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[859922]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[203283]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[204435]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[205587]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[206739]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[207891]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[209043]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[210195]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[211347]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[854163]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[857619]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[858771]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[859923]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[203284]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[204436]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[205588]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[206740]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[207892]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[209044]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[210196]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[211348]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[855316]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[857620]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[858772]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[859924]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[203285]=iiota*Pssp*zbar;
	Mxe_sp_s[206741]=iiota*Pssp*zbar;
	Mxe_sp_s[855317]=-Pssp;
	Mxe_sp_s[849558]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[856470]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[858774]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[859926]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[204439]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[205591]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[206743]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[207895]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[210199]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[848407]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[849559]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[850711]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[851863]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[854167]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[856471]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[858775]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[859927]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[203288]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[206744]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[851864]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[858776]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[859928]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[203289]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[204441]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[206745]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[207897]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[849561]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[850713]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[854169]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[855321]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[856473]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[858777]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[859929]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[858778]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[859930]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[204443]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[209051]=Pssp;
	Mxe_sp_s[854171]=-Pssp;
	Mxe_sp_s[858779]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[859931]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[203292]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[853020]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[205597]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[206749]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[207901]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[849565]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[850717]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[858781]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[859933]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[861085]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[204446]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[206750]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[858782]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[859934]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[861086]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[862238]=Pssp;
	Mxe_sp_s[204447]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[206751]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[858783]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[859935]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[861087]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[863391]=Pssp;
	Mxe_sp_s[210208]=ebar*Pssp;
	Mxe_sp_s[848416]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[851872]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[858784]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[859936]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[861088]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[864544]=Pssp;
	Mxe_sp_s[203297]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[204449]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[205601]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[206753]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[207905]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[209057]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[210209]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[211361]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[858785]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[859937]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[865697]=Pssp;
	Mxe_sp_s[205602]=-Pssp;
	Mxe_sp_s[206755]=-Pssp;
	Mxe_sp_s[207908]=-Pssp;
	Mxe_sp_s[211365]=-Pssp;
	Mxe_sp_s[210214]=-Pssp;
	Mxe_sp_s[209063]=-Pssp;
	Mxe_sp_s[220584]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[866856]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[868008]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[876072]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[877224]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[878376]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[214825]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[215977]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[217129]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[868009]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[869161]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[872617]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[876073]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[877225]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[878377]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[214826]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[215978]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[868010]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[869162]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[872618]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[874922]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[876074]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[877226]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[878378]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[212523]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[213675]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[214827]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[215979]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[217131]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[218283]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[219435]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[220587]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[872619]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[876075]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[877227]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[878379]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[212524]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[213676]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[214828]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[215980]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[217132]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[218284]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[219436]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[220588]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[873772]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[876076]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[877228]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[878380]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[212525]=iiota*Pssp*zbar;
	Mxe_sp_s[215981]=iiota*Pssp*zbar;
	Mxe_sp_s[873773]=-Pssp;
	Mxe_sp_s[868014]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[874926]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[877230]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[878382]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[213679]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[214831]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[215983]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[217135]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[219439]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[866863]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[868015]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[869167]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[870319]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[872623]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[874927]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[877231]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[878383]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[212528]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[215984]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[870320]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[877232]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[878384]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[212529]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[213681]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[215985]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[217137]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[868017]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[869169]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[872625]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[873777]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[874929]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[877233]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[878385]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[877234]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[878386]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[213683]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[218291]=Pssp;
	Mxe_sp_s[872627]=-Pssp;
	Mxe_sp_s[877235]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[878387]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[212532]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[871476]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[214837]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[215989]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[217141]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[868021]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[869173]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[877237]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[878389]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[879541]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[213686]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[215990]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[877238]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[878390]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[879542]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[880694]=Pssp;
	Mxe_sp_s[213687]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[215991]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[877239]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[878391]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[879543]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[881847]=Pssp;
	Mxe_sp_s[219448]=ebar*Pssp;
	Mxe_sp_s[866872]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[870328]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[877240]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[878392]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[879544]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[883000]=Pssp;
	Mxe_sp_s[212537]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[213689]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[214841]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[215993]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[217145]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[218297]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[219449]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[220601]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[877241]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[878393]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[884153]=Pssp;
	Mxe_sp_s[214842]=-Pssp;
	Mxe_sp_s[215995]=-Pssp;
	Mxe_sp_s[217148]=-Pssp;
	Mxe_sp_s[220605]=-Pssp;
	Mxe_sp_s[219454]=-Pssp;
	Mxe_sp_s[218303]=-Pssp;
	Mxe_sp_s[229824]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[885312]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[886464]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[894528]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[895680]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[896832]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[224065]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[225217]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[226369]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[886465]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[887617]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[891073]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[894529]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[895681]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[896833]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[224066]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[225218]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[886466]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[887618]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[891074]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[893378]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[894530]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[895682]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[896834]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[221763]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[222915]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[224067]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[225219]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[226371]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[227523]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[228675]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[229827]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[891075]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[894531]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[895683]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[896835]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[221764]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[222916]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[224068]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[225220]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[226372]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[227524]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[228676]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[229828]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[892228]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[894532]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[895684]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[896836]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[221765]=iiota*Pssp*zbar;
	Mxe_sp_s[225221]=iiota*Pssp*zbar;
	Mxe_sp_s[892229]=-Pssp;
	Mxe_sp_s[886470]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[893382]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[895686]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[896838]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[222919]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[224071]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[225223]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[226375]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[228679]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[885319]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[886471]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[887623]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[888775]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[891079]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[893383]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[895687]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[896839]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[221768]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[225224]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[888776]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[895688]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[896840]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[221769]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[222921]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[225225]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[226377]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[886473]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[887625]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[891081]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[892233]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[893385]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[895689]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[896841]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[895690]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[896842]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[222923]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[227531]=Pssp;
	Mxe_sp_s[891083]=-Pssp;
	Mxe_sp_s[895691]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[896843]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[221772]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[889932]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[224077]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[225229]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[226381]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[886477]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[887629]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[895693]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[896845]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[897997]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[222926]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[225230]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[895694]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[896846]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[897998]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[899150]=Pssp;
	Mxe_sp_s[222927]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[225231]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[895695]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[896847]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[897999]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[900303]=Pssp;
	Mxe_sp_s[228688]=ebar*Pssp;
	Mxe_sp_s[885328]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[888784]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[895696]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[896848]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[898000]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[901456]=Pssp;
	Mxe_sp_s[221777]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[222929]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[224081]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[225233]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[226385]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[227537]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[228689]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[229841]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[895697]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[896849]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[902609]=Pssp;
	Mxe_sp_s[224082]=-Pssp;
	Mxe_sp_s[225235]=-Pssp;
	Mxe_sp_s[226388]=-Pssp;
	Mxe_sp_s[229845]=-Pssp;
	Mxe_sp_s[228694]=-Pssp;
	Mxe_sp_s[227543]=-Pssp;
	Mxe_sp_s[239064]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[903768]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[904920]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[912984]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[914136]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[915288]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[233305]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[234457]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[235609]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[904921]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[906073]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[909529]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[912985]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[914137]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[915289]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[233306]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[234458]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[904922]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[906074]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[909530]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[911834]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[912986]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[914138]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[915290]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[231003]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[232155]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[233307]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[234459]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[235611]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[236763]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[237915]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[239067]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[909531]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[912987]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[914139]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[915291]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[231004]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[232156]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[233308]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[234460]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[235612]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[236764]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[237916]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[239068]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[910684]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[912988]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[914140]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[915292]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[231005]=iiota*Pssp*zbar;
	Mxe_sp_s[234461]=iiota*Pssp*zbar;
	Mxe_sp_s[910685]=-Pssp;
	Mxe_sp_s[904926]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[911838]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[914142]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[915294]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[232159]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[233311]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[234463]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[235615]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[237919]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[903775]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[904927]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[906079]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[907231]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[909535]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[911839]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[914143]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[915295]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[231008]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[234464]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[907232]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[914144]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[915296]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[231009]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[232161]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[234465]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[235617]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[904929]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[906081]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[909537]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[910689]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[911841]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[914145]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[915297]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[914146]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[915298]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[232163]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[236771]=Pssp;
	Mxe_sp_s[909539]=-Pssp;
	Mxe_sp_s[914147]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[915299]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[231012]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[908388]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[233317]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[234469]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[235621]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[904933]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[906085]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[914149]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[915301]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[916453]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[232166]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[234470]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[914150]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[915302]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[916454]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[917606]=Pssp;
	Mxe_sp_s[232167]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[234471]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[914151]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[915303]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[916455]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[918759]=Pssp;
	Mxe_sp_s[237928]=ebar*Pssp;
	Mxe_sp_s[903784]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[907240]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[914152]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[915304]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[916456]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[919912]=Pssp;
	Mxe_sp_s[231017]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[232169]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[233321]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[234473]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[235625]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[236777]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[237929]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[239081]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[914153]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[915305]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[921065]=Pssp;
	Mxe_sp_s[233322]=-Pssp;
	Mxe_sp_s[234475]=-Pssp;
	Mxe_sp_s[235628]=-Pssp;
	Mxe_sp_s[239085]=-Pssp;
	Mxe_sp_s[237934]=-Pssp;
	Mxe_sp_s[236783]=-Pssp;
	Mxe_sp_s[248304]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[922224]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[923376]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[931440]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[932592]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[933744]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[242545]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[243697]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[244849]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[923377]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[924529]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[927985]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[931441]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[932593]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[933745]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[242546]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[243698]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[923378]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[924530]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[927986]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[930290]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[931442]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[932594]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[933746]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[240243]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[241395]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[242547]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[243699]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[244851]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[246003]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[247155]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[248307]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[927987]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[931443]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[932595]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[933747]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[240244]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[241396]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[242548]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[243700]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[244852]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[246004]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[247156]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[248308]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[929140]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[931444]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[932596]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[933748]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[240245]=iiota*Pssp*zbar;
	Mxe_sp_s[243701]=iiota*Pssp*zbar;
	Mxe_sp_s[929141]=-Pssp;
	Mxe_sp_s[923382]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[930294]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[932598]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[933750]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[241399]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[242551]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[243703]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[244855]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[247159]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[922231]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[923383]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[924535]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[925687]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[927991]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[930295]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[932599]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[933751]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[240248]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[243704]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[925688]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[932600]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[933752]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[240249]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[241401]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[243705]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[244857]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[923385]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[924537]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[927993]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[929145]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[930297]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[932601]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[933753]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[932602]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[933754]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[241403]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[246011]=Pssp;
	Mxe_sp_s[927995]=-Pssp;
	Mxe_sp_s[932603]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[933755]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[240252]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[926844]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[242557]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[243709]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[244861]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[923389]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[924541]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[932605]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[933757]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[934909]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[241406]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[243710]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[932606]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[933758]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[934910]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[936062]=Pssp;
	Mxe_sp_s[241407]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[243711]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[932607]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[933759]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[934911]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[937215]=Pssp;
	Mxe_sp_s[247168]=ebar*Pssp;
	Mxe_sp_s[922240]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[925696]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[932608]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[933760]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[934912]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[938368]=Pssp;
	Mxe_sp_s[240257]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[241409]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[242561]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[243713]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[244865]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[246017]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[247169]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[248321]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[932609]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[933761]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[939521]=Pssp;
	Mxe_sp_s[242562]=-Pssp;
	Mxe_sp_s[243715]=-Pssp;
	Mxe_sp_s[244868]=-Pssp;
	Mxe_sp_s[248325]=-Pssp;
	Mxe_sp_s[247174]=-Pssp;
	Mxe_sp_s[246023]=-Pssp;
	Mxe_sp_s[257544]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[940680]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[941832]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[949896]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[951048]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[952200]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[251785]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[252937]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[254089]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[941833]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[942985]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[946441]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[949897]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[951049]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[952201]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[251786]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[252938]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[941834]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[942986]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[946442]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[948746]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[949898]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[951050]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[952202]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[249483]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[250635]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[251787]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[252939]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[254091]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[255243]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[256395]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[257547]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[946443]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[949899]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[951051]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[952203]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[249484]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[250636]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[251788]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[252940]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[254092]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[255244]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[256396]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[257548]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[947596]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[949900]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[951052]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[952204]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[249485]=iiota*Pssp*zbar;
	Mxe_sp_s[252941]=iiota*Pssp*zbar;
	Mxe_sp_s[947597]=-Pssp;
	Mxe_sp_s[941838]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[948750]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[951054]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[952206]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[250639]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[251791]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[252943]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[254095]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[256399]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[940687]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[941839]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[942991]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[944143]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[946447]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[948751]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[951055]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[952207]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[249488]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[252944]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[944144]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[951056]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[952208]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[249489]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[250641]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[252945]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[254097]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[941841]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[942993]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[946449]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[947601]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[948753]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[951057]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[952209]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[951058]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[952210]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[250643]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[255251]=Pssp;
	Mxe_sp_s[946451]=-Pssp;
	Mxe_sp_s[951059]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[952211]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[249492]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[945300]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[251797]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[252949]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[254101]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[941845]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[942997]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[951061]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[952213]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[953365]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[250646]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[252950]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[951062]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[952214]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[953366]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[954518]=Pssp;
	Mxe_sp_s[250647]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[252951]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[951063]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[952215]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[953367]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[955671]=Pssp;
	Mxe_sp_s[256408]=ebar*Pssp;
	Mxe_sp_s[940696]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[944152]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[951064]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[952216]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[953368]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[956824]=Pssp;
	Mxe_sp_s[249497]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[250649]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[251801]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[252953]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[254105]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[255257]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[256409]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[257561]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[951065]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[952217]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[957977]=Pssp;
	Mxe_sp_s[251802]=-Pssp;
	Mxe_sp_s[252955]=-Pssp;
	Mxe_sp_s[254108]=-Pssp;
	Mxe_sp_s[257565]=-Pssp;
	Mxe_sp_s[256414]=-Pssp;
	Mxe_sp_s[255263]=-Pssp;
	Mxe_sp_s[266784]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[959136]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[960288]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[968352]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[969504]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[970656]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[261025]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[262177]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[263329]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[960289]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[961441]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[964897]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[968353]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[969505]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[970657]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[261026]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[262178]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[960290]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[961442]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[964898]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[967202]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[968354]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[969506]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[970658]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[258723]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[259875]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[261027]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[262179]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[263331]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[264483]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[265635]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[266787]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[964899]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[968355]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[969507]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[970659]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[258724]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[259876]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[261028]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[262180]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[263332]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[264484]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[265636]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[266788]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[966052]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[968356]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[969508]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[970660]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[258725]=iiota*Pssp*zbar;
	Mxe_sp_s[262181]=iiota*Pssp*zbar;
	Mxe_sp_s[966053]=-Pssp;
	Mxe_sp_s[960294]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[967206]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[969510]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[970662]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[259879]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[261031]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[262183]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[263335]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[265639]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[959143]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[960295]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[961447]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[962599]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[964903]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[967207]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[969511]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[970663]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[258728]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[262184]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[962600]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[969512]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[970664]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[258729]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[259881]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[262185]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[263337]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[960297]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[961449]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[964905]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[966057]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[967209]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[969513]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[970665]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[969514]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[970666]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[259883]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[264491]=Pssp;
	Mxe_sp_s[964907]=-Pssp;
	Mxe_sp_s[969515]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[970667]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[258732]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[963756]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[261037]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[262189]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[263341]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[960301]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[961453]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[969517]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[970669]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[971821]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[259886]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[262190]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[969518]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[970670]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[971822]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[972974]=Pssp;
	Mxe_sp_s[259887]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[262191]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[969519]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[970671]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[971823]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[974127]=Pssp;
	Mxe_sp_s[265648]=ebar*Pssp;
	Mxe_sp_s[959152]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[962608]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[969520]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[970672]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[971824]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[975280]=Pssp;
	Mxe_sp_s[258737]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[259889]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[261041]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[262193]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[263345]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[264497]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[265649]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[266801]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[969521]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[970673]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[976433]=Pssp;
	Mxe_sp_s[261042]=-Pssp;
	Mxe_sp_s[262195]=-Pssp;
	Mxe_sp_s[263348]=-Pssp;
	Mxe_sp_s[266805]=-Pssp;
	Mxe_sp_s[265654]=-Pssp;
	Mxe_sp_s[264503]=-Pssp;
	Mxe_sp_s[276024]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[977592]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[978744]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[986808]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[987960]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[989112]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[270265]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[271417]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[272569]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[978745]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[979897]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[983353]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[986809]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[987961]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[989113]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[270266]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[271418]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[978746]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[979898]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[983354]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[985658]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[986810]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[987962]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[989114]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[267963]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[269115]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[270267]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[271419]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[272571]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[273723]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[274875]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[276027]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[983355]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[986811]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[987963]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[989115]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[267964]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[269116]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[270268]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[271420]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[272572]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[273724]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[274876]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[276028]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[984508]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[986812]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[987964]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[989116]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[267965]=iiota*Pssp*zbar;
	Mxe_sp_s[271421]=iiota*Pssp*zbar;
	Mxe_sp_s[984509]=-Pssp;
	Mxe_sp_s[978750]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[985662]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[987966]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[989118]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[269119]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[270271]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[271423]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[272575]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[274879]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[977599]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[978751]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[979903]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[981055]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[983359]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[985663]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[987967]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[989119]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[267968]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[271424]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[981056]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[987968]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[989120]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[267969]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[269121]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[271425]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[272577]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[978753]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[979905]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[983361]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[984513]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[985665]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[987969]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[989121]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[987970]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[989122]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[269123]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[273731]=Pssp;
	Mxe_sp_s[983363]=-Pssp;
	Mxe_sp_s[987971]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[989123]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[267972]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[982212]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[270277]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[271429]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[272581]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[978757]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[979909]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[987973]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[989125]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[990277]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[269126]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[271430]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[987974]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[989126]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[990278]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[991430]=Pssp;
	Mxe_sp_s[269127]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[271431]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[987975]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[989127]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[990279]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[992583]=Pssp;
	Mxe_sp_s[274888]=ebar*Pssp;
	Mxe_sp_s[977608]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[981064]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[987976]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[989128]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[990280]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[993736]=Pssp;
	Mxe_sp_s[267977]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[269129]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[270281]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[271433]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[272585]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[273737]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[274889]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[276041]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[987977]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[989129]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[994889]=Pssp;
	Mxe_sp_s[270282]=-Pssp;
	Mxe_sp_s[271435]=-Pssp;
	Mxe_sp_s[272588]=-Pssp;
	Mxe_sp_s[276045]=-Pssp;
	Mxe_sp_s[274894]=-Pssp;
	Mxe_sp_s[273743]=-Pssp;
	Mxe_sp_s[285264]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[996048]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[997200]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[1005264]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1006416]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[1007568]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[279505]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[280657]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[281809]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[997201]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[998353]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1001809]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[1005265]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[1006417]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1007569]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[279506]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[280658]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[997202]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[998354]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1001810]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[1004114]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1005266]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[1006418]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1007570]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[277203]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[278355]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[279507]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[280659]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[281811]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[282963]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[284115]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[285267]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1001811]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[1005267]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1006419]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[1007571]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[277204]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[278356]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[279508]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[280660]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[281812]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[282964]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[284116]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[285268]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[1002964]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[1005268]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[1006420]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[1007572]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[277205]=iiota*Pssp*zbar;
	Mxe_sp_s[280661]=iiota*Pssp*zbar;
	Mxe_sp_s[1002965]=-Pssp;
	Mxe_sp_s[997206]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[1004118]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[1006422]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1007574]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[278359]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[279511]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[280663]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[281815]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[284119]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[996055]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[997207]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[998359]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[999511]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[1001815]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1004119]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[1006423]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[1007575]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[277208]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[280664]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[999512]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[1006424]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[1007576]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[277209]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[278361]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[280665]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[281817]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[997209]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[998361]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1001817]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1002969]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1004121]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1006425]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1007577]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1006426]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1007578]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[278363]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[282971]=Pssp;
	Mxe_sp_s[1001819]=-Pssp;
	Mxe_sp_s[1006427]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[1007579]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[277212]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[1000668]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[279517]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[280669]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[281821]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[997213]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[998365]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[1006429]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1007581]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1008733]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[278366]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[280670]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1006430]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1007582]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1008734]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1009886]=Pssp;
	Mxe_sp_s[278367]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[280671]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1006431]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1007583]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1008735]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1011039]=Pssp;
	Mxe_sp_s[284128]=ebar*Pssp;
	Mxe_sp_s[996064]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[999520]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[1006432]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1007584]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1008736]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[1012192]=Pssp;
	Mxe_sp_s[277217]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[278369]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[279521]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[280673]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[281825]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[282977]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[284129]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[285281]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1006433]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1007585]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1013345]=Pssp;
	Mxe_sp_s[279522]=-Pssp;
	Mxe_sp_s[280675]=-Pssp;
	Mxe_sp_s[281828]=-Pssp;
	Mxe_sp_s[285285]=-Pssp;
	Mxe_sp_s[284134]=-Pssp;
	Mxe_sp_s[282983]=-Pssp;
	Mxe_sp_s[294504]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[1014504]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[1015656]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[1023720]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1024872]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[1026024]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[288745]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[289897]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[291049]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1015657]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1016809]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1020265]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[1023721]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[1024873]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1026025]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[288746]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[289898]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1015658]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1016810]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1020266]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[1022570]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1023722]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[1024874]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1026026]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[286443]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[287595]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[288747]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[289899]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[291051]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[292203]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[293355]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[294507]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1020267]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[1023723]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1024875]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[1026027]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[286444]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[287596]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[288748]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[289900]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[291052]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[292204]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[293356]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[294508]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[1021420]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[1023724]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[1024876]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[1026028]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[286445]=iiota*Pssp*zbar;
	Mxe_sp_s[289901]=iiota*Pssp*zbar;
	Mxe_sp_s[1021421]=-Pssp;
	Mxe_sp_s[1015662]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[1022574]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[1024878]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1026030]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[287599]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[288751]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[289903]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[291055]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[293359]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[1014511]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[1015663]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[1016815]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[1017967]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[1020271]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1022575]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[1024879]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[1026031]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[286448]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[289904]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[1017968]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[1024880]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[1026032]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[286449]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[287601]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[289905]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[291057]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1015665]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1016817]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1020273]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1021425]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1022577]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1024881]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1026033]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1024882]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1026034]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[287603]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[292211]=Pssp;
	Mxe_sp_s[1020275]=-Pssp;
	Mxe_sp_s[1024883]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[1026035]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[286452]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[1019124]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[288757]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[289909]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[291061]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[1015669]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1016821]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[1024885]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1026037]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1027189]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[287606]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[289910]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1024886]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1026038]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1027190]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1028342]=Pssp;
	Mxe_sp_s[287607]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[289911]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1024887]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1026039]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1027191]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1029495]=Pssp;
	Mxe_sp_s[293368]=ebar*Pssp;
	Mxe_sp_s[1014520]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[1017976]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[1024888]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1026040]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1027192]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[1030648]=Pssp;
	Mxe_sp_s[286457]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[287609]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[288761]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[289913]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[291065]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[292217]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[293369]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[294521]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1024889]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1026041]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1031801]=Pssp;
	Mxe_sp_s[288762]=-Pssp;
	Mxe_sp_s[289915]=-Pssp;
	Mxe_sp_s[291068]=-Pssp;
	Mxe_sp_s[294525]=-Pssp;
	Mxe_sp_s[293374]=-Pssp;
	Mxe_sp_s[292223]=-Pssp;
	Mxe_sp_s[303744]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[1032960]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[1034112]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[1042176]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1043328]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[1044480]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[297985]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[299137]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[300289]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1034113]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1035265]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1038721]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[1042177]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[1043329]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1044481]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[297986]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[299138]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1034114]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1035266]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1038722]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[1041026]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1042178]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[1043330]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1044482]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[295683]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[296835]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[297987]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[299139]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[300291]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[301443]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[302595]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[303747]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1038723]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[1042179]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1043331]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[1044483]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[295684]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[296836]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[297988]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[299140]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[300292]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[301444]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[302596]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[303748]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[1039876]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[1042180]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[1043332]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[1044484]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[295685]=iiota*Pssp*zbar;
	Mxe_sp_s[299141]=iiota*Pssp*zbar;
	Mxe_sp_s[1039877]=-Pssp;
	Mxe_sp_s[1034118]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[1041030]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[1043334]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1044486]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[296839]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[297991]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[299143]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[300295]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[302599]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[1032967]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[1034119]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[1035271]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[1036423]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[1038727]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1041031]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[1043335]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[1044487]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[295688]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[299144]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[1036424]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[1043336]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[1044488]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[295689]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[296841]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[299145]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[300297]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1034121]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1035273]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1038729]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1039881]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1041033]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1043337]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1044489]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1043338]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1044490]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[296843]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[301451]=Pssp;
	Mxe_sp_s[1038731]=-Pssp;
	Mxe_sp_s[1043339]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[1044491]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[295692]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[1037580]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[297997]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[299149]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[300301]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[1034125]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1035277]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[1043341]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1044493]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1045645]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[296846]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[299150]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1043342]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1044494]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1045646]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1046798]=Pssp;
	Mxe_sp_s[296847]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[299151]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1043343]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1044495]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1045647]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1047951]=Pssp;
	Mxe_sp_s[302608]=ebar*Pssp;
	Mxe_sp_s[1032976]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[1036432]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[1043344]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1044496]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1045648]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[1049104]=Pssp;
	Mxe_sp_s[295697]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[296849]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[298001]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[299153]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[300305]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[301457]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[302609]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[303761]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1043345]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1044497]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1050257]=Pssp;
	Mxe_sp_s[298002]=-Pssp;
	Mxe_sp_s[299155]=-Pssp;
	Mxe_sp_s[300308]=-Pssp;
	Mxe_sp_s[303765]=-Pssp;
	Mxe_sp_s[302614]=-Pssp;
	Mxe_sp_s[301463]=-Pssp;
	Mxe_sp_s[312984]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[1051416]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[1052568]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[1060632]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1061784]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[1062936]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[307225]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[308377]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[309529]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1052569]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1053721]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1057177]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[1060633]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[1061785]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1062937]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[307226]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[308378]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1052570]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1053722]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1057178]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[1059482]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1060634]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[1061786]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1062938]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[304923]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[306075]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[307227]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[308379]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[309531]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[310683]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[311835]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[312987]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1057179]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[1060635]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1061787]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[1062939]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[304924]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[306076]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[307228]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[308380]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[309532]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[310684]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[311836]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[312988]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[1058332]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[1060636]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[1061788]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[1062940]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[304925]=iiota*Pssp*zbar;
	Mxe_sp_s[308381]=iiota*Pssp*zbar;
	Mxe_sp_s[1058333]=-Pssp;
	Mxe_sp_s[1052574]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[1059486]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[1061790]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1062942]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[306079]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[307231]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[308383]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[309535]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[311839]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[1051423]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[1052575]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[1053727]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[1054879]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[1057183]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1059487]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[1061791]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[1062943]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[304928]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[308384]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[1054880]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[1061792]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[1062944]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[304929]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[306081]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[308385]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[309537]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1052577]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1053729]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1057185]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1058337]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1059489]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1061793]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1062945]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1061794]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1062946]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[306083]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[310691]=Pssp;
	Mxe_sp_s[1057187]=-Pssp;
	Mxe_sp_s[1061795]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[1062947]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[304932]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[1056036]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[307237]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[308389]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[309541]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[1052581]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1053733]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[1061797]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1062949]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1064101]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[306086]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[308390]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1061798]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1062950]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1064102]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1065254]=Pssp;
	Mxe_sp_s[306087]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[308391]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1061799]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1062951]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1064103]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1066407]=Pssp;
	Mxe_sp_s[311848]=ebar*Pssp;
	Mxe_sp_s[1051432]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[1054888]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[1061800]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1062952]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1064104]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[1067560]=Pssp;
	Mxe_sp_s[304937]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[306089]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[307241]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[308393]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[309545]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[310697]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[311849]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[313001]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1061801]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1062953]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1068713]=Pssp;
	Mxe_sp_s[307242]=-Pssp;
	Mxe_sp_s[308395]=-Pssp;
	Mxe_sp_s[309548]=-Pssp;
	Mxe_sp_s[313005]=-Pssp;
	Mxe_sp_s[311854]=-Pssp;
	Mxe_sp_s[310703]=-Pssp;
	Mxe_sp_s[322224]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[1069872]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[1071024]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[1079088]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1080240]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[1081392]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[316465]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[317617]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[318769]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1071025]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1072177]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1075633]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[1079089]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[1080241]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1081393]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[316466]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[317618]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1071026]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1072178]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1075634]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[1077938]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1079090]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[1080242]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1081394]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[314163]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[315315]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[316467]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[317619]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[318771]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[319923]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[321075]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[322227]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1075635]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[1079091]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1080243]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[1081395]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[314164]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[315316]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[316468]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[317620]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[318772]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[319924]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[321076]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[322228]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[1076788]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[1079092]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[1080244]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[1081396]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[314165]=iiota*Pssp*zbar;
	Mxe_sp_s[317621]=iiota*Pssp*zbar;
	Mxe_sp_s[1076789]=-Pssp;
	Mxe_sp_s[1071030]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[1077942]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[1080246]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1081398]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[315319]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[316471]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[317623]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[318775]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[321079]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[1069879]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[1071031]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[1072183]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[1073335]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[1075639]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1077943]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[1080247]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[1081399]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[314168]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[317624]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[1073336]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[1080248]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[1081400]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[314169]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[315321]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[317625]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[318777]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1071033]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1072185]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1075641]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1076793]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1077945]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1080249]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1081401]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1080250]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1081402]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[315323]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[319931]=Pssp;
	Mxe_sp_s[1075643]=-Pssp;
	Mxe_sp_s[1080251]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[1081403]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[314172]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[1074492]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[316477]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[317629]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[318781]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[1071037]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1072189]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[1080253]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1081405]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1082557]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[315326]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[317630]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1080254]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1081406]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1082558]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1083710]=Pssp;
	Mxe_sp_s[315327]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[317631]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1080255]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1081407]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1082559]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1084863]=Pssp;
	Mxe_sp_s[321088]=ebar*Pssp;
	Mxe_sp_s[1069888]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[1073344]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[1080256]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1081408]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1082560]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[1086016]=Pssp;
	Mxe_sp_s[314177]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[315329]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[316481]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[317633]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[318785]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[319937]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[321089]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[322241]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1080257]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1081409]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1087169]=Pssp;
	Mxe_sp_s[316482]=-Pssp;
	Mxe_sp_s[317635]=-Pssp;
	Mxe_sp_s[318788]=-Pssp;
	Mxe_sp_s[322245]=-Pssp;
	Mxe_sp_s[321094]=-Pssp;
	Mxe_sp_s[319943]=-Pssp;
	Mxe_sp_s[331464]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[1088328]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[1089480]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[1097544]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1098696]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[1099848]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[325705]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[326857]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[328009]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1089481]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1090633]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1094089]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[1097545]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[1098697]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1099849]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[325706]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[326858]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1089482]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1090634]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1094090]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[1096394]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1097546]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[1098698]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1099850]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[323403]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[324555]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[325707]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[326859]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[328011]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[329163]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[330315]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[331467]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1094091]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[1097547]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1098699]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[1099851]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[323404]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[324556]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[325708]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[326860]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[328012]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[329164]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[330316]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[331468]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[1095244]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[1097548]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[1098700]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[1099852]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[323405]=iiota*Pssp*zbar;
	Mxe_sp_s[326861]=iiota*Pssp*zbar;
	Mxe_sp_s[1095245]=-Pssp;
	Mxe_sp_s[1089486]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[1096398]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[1098702]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1099854]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[324559]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[325711]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[326863]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[328015]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[330319]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[1088335]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[1089487]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[1090639]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[1091791]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[1094095]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1096399]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[1098703]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[1099855]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[323408]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[326864]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[1091792]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[1098704]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[1099856]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[323409]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[324561]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[326865]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[328017]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1089489]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1090641]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1094097]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1095249]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1096401]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1098705]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1099857]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1098706]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1099858]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[324563]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[329171]=Pssp;
	Mxe_sp_s[1094099]=-Pssp;
	Mxe_sp_s[1098707]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[1099859]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[323412]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[1092948]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[325717]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[326869]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[328021]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[1089493]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1090645]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[1098709]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1099861]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1101013]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[324566]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[326870]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1098710]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1099862]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1101014]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1102166]=Pssp;
	Mxe_sp_s[324567]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[326871]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1098711]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1099863]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1101015]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1103319]=Pssp;
	Mxe_sp_s[330328]=ebar*Pssp;
	Mxe_sp_s[1088344]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[1091800]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[1098712]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1099864]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1101016]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[1104472]=Pssp;
	Mxe_sp_s[323417]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[324569]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[325721]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[326873]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[328025]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[329177]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[330329]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[331481]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1098713]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1099865]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1105625]=Pssp;
	Mxe_sp_s[325722]=-Pssp;
	Mxe_sp_s[326875]=-Pssp;
	Mxe_sp_s[328028]=-Pssp;
	Mxe_sp_s[331485]=-Pssp;
	Mxe_sp_s[330334]=-Pssp;
	Mxe_sp_s[329183]=-Pssp;
	Mxe_sp_s[340704]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[1106784]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[1107936]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[1116000]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1117152]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[1118304]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[334945]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[336097]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[337249]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1107937]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1109089]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1112545]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[1116001]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[1117153]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1118305]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[334946]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[336098]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1107938]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1109090]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1112546]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[1114850]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1116002]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[1117154]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1118306]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[332643]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[333795]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[334947]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[336099]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[337251]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[338403]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[339555]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[340707]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1112547]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[1116003]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1117155]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[1118307]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[332644]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[333796]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[334948]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[336100]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[337252]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[338404]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[339556]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[340708]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[1113700]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[1116004]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[1117156]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[1118308]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[332645]=iiota*Pssp*zbar;
	Mxe_sp_s[336101]=iiota*Pssp*zbar;
	Mxe_sp_s[1113701]=-Pssp;
	Mxe_sp_s[1107942]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[1114854]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[1117158]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1118310]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[333799]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[334951]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[336103]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[337255]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[339559]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[1106791]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[1107943]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[1109095]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[1110247]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[1112551]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1114855]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[1117159]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[1118311]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[332648]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[336104]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[1110248]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[1117160]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[1118312]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[332649]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[333801]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[336105]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[337257]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1107945]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1109097]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1112553]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1113705]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1114857]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1117161]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1118313]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1117162]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1118314]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[333803]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[338411]=Pssp;
	Mxe_sp_s[1112555]=-Pssp;
	Mxe_sp_s[1117163]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[1118315]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[332652]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[1111404]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[334957]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[336109]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[337261]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[1107949]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1109101]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[1117165]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1118317]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1119469]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[333806]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[336110]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1117166]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1118318]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1119470]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1120622]=Pssp;
	Mxe_sp_s[333807]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[336111]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1117167]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1118319]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1119471]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1121775]=Pssp;
	Mxe_sp_s[339568]=ebar*Pssp;
	Mxe_sp_s[1106800]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[1110256]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[1117168]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1118320]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1119472]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[1122928]=Pssp;
	Mxe_sp_s[332657]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[333809]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[334961]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[336113]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[337265]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[338417]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[339569]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[340721]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1117169]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1118321]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1124081]=Pssp;
	Mxe_sp_s[334962]=-Pssp;
	Mxe_sp_s[336115]=-Pssp;
	Mxe_sp_s[337268]=-Pssp;
	Mxe_sp_s[340725]=-Pssp;
	Mxe_sp_s[339574]=-Pssp;
	Mxe_sp_s[338423]=-Pssp;
	Mxe_sp_s[349944]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[1125240]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[1126392]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[1134456]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1135608]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[1136760]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[344185]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[345337]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[346489]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1126393]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1127545]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1131001]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[1134457]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[1135609]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1136761]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[344186]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[345338]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1126394]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1127546]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1131002]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[1133306]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1134458]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[1135610]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1136762]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[341883]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[343035]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[344187]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[345339]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[346491]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[347643]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[348795]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[349947]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1131003]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[1134459]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1135611]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[1136763]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[341884]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[343036]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[344188]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[345340]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[346492]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[347644]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[348796]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[349948]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[1132156]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[1134460]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[1135612]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[1136764]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[341885]=iiota*Pssp*zbar;
	Mxe_sp_s[345341]=iiota*Pssp*zbar;
	Mxe_sp_s[1132157]=-Pssp;
	Mxe_sp_s[1126398]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[1133310]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[1135614]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1136766]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[343039]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[344191]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[345343]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[346495]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[348799]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[1125247]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[1126399]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[1127551]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[1128703]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[1131007]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1133311]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[1135615]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[1136767]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[341888]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[345344]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[1128704]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[1135616]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[1136768]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[341889]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[343041]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[345345]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[346497]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1126401]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1127553]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1131009]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1132161]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1133313]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1135617]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1136769]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1135618]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1136770]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[343043]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[347651]=Pssp;
	Mxe_sp_s[1131011]=-Pssp;
	Mxe_sp_s[1135619]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[1136771]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[341892]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[1129860]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[344197]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[345349]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[346501]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[1126405]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1127557]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[1135621]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1136773]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1137925]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[343046]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[345350]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1135622]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1136774]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1137926]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1139078]=Pssp;
	Mxe_sp_s[343047]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[345351]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1135623]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1136775]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1137927]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1140231]=Pssp;
	Mxe_sp_s[348808]=ebar*Pssp;
	Mxe_sp_s[1125256]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[1128712]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[1135624]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1136776]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1137928]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[1141384]=Pssp;
	Mxe_sp_s[341897]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[343049]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[344201]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[345353]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[346505]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[347657]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[348809]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[349961]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1135625]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1136777]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1142537]=Pssp;
	Mxe_sp_s[344202]=-Pssp;
	Mxe_sp_s[345355]=-Pssp;
	Mxe_sp_s[346508]=-Pssp;
	Mxe_sp_s[349965]=-Pssp;
	Mxe_sp_s[348814]=-Pssp;
	Mxe_sp_s[347663]=-Pssp;
	Mxe_sp_s[359184]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[1143696]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[1144848]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[1152912]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1154064]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[1155216]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[353425]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[354577]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[355729]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1144849]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1146001]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1149457]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[1152913]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[1154065]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1155217]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[353426]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[354578]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1144850]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1146002]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1149458]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[1151762]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1152914]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[1154066]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1155218]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[351123]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[352275]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[353427]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[354579]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[355731]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[356883]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[358035]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[359187]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1149459]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[1152915]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1154067]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[1155219]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[351124]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[352276]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[353428]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[354580]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[355732]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[356884]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[358036]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[359188]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[1150612]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[1152916]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[1154068]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[1155220]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[351125]=iiota*Pssp*zbar;
	Mxe_sp_s[354581]=iiota*Pssp*zbar;
	Mxe_sp_s[1150613]=-Pssp;
	Mxe_sp_s[1144854]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[1151766]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[1154070]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1155222]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[352279]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[353431]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[354583]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[355735]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[358039]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[1143703]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[1144855]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[1146007]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[1147159]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[1149463]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1151767]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[1154071]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[1155223]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[351128]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[354584]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[1147160]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[1154072]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[1155224]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[351129]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[352281]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[354585]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[355737]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1144857]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1146009]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1149465]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1150617]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1151769]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1154073]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1155225]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1154074]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1155226]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[352283]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[356891]=Pssp;
	Mxe_sp_s[1149467]=-Pssp;
	Mxe_sp_s[1154075]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[1155227]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[351132]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[1148316]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[353437]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[354589]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[355741]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[1144861]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1146013]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[1154077]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1155229]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1156381]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[352286]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[354590]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1154078]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1155230]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1156382]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1157534]=Pssp;
	Mxe_sp_s[352287]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[354591]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1154079]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1155231]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1156383]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1158687]=Pssp;
	Mxe_sp_s[358048]=ebar*Pssp;
	Mxe_sp_s[1143712]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[1147168]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[1154080]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1155232]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1156384]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[1159840]=Pssp;
	Mxe_sp_s[351137]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[352289]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[353441]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[354593]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[355745]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[356897]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[358049]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[359201]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1154081]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1155233]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1160993]=Pssp;
	Mxe_sp_s[353442]=-Pssp;
	Mxe_sp_s[354595]=-Pssp;
	Mxe_sp_s[355748]=-Pssp;
	Mxe_sp_s[359205]=-Pssp;
	Mxe_sp_s[358054]=-Pssp;
	Mxe_sp_s[356903]=-Pssp;
	Mxe_sp_s[368424]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[1162152]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[1163304]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[1171368]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1172520]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[1173672]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[362665]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[363817]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[364969]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1163305]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1164457]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1167913]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[1171369]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[1172521]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1173673]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[362666]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[363818]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1163306]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1164458]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1167914]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[1170218]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1171370]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[1172522]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1173674]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[360363]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[361515]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[362667]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[363819]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[364971]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[366123]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[367275]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[368427]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1167915]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[1171371]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1172523]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[1173675]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[360364]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[361516]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[362668]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[363820]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[364972]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[366124]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[367276]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[368428]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[1169068]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[1171372]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[1172524]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[1173676]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[360365]=iiota*Pssp*zbar;
	Mxe_sp_s[363821]=iiota*Pssp*zbar;
	Mxe_sp_s[1169069]=-Pssp;
	Mxe_sp_s[1163310]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[1170222]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[1172526]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1173678]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[361519]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[362671]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[363823]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[364975]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[367279]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[1162159]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[1163311]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[1164463]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[1165615]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[1167919]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1170223]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[1172527]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[1173679]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[360368]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[363824]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[1165616]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[1172528]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[1173680]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[360369]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[361521]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[363825]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[364977]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1163313]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1164465]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1167921]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1169073]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1170225]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1172529]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1173681]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1172530]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1173682]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[361523]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[366131]=Pssp;
	Mxe_sp_s[1167923]=-Pssp;
	Mxe_sp_s[1172531]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[1173683]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[360372]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[1166772]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[362677]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[363829]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[364981]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[1163317]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1164469]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[1172533]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1173685]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1174837]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[361526]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[363830]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1172534]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1173686]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1174838]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1175990]=Pssp;
	Mxe_sp_s[361527]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[363831]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1172535]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1173687]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1174839]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1177143]=Pssp;
	Mxe_sp_s[367288]=ebar*Pssp;
	Mxe_sp_s[1162168]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[1165624]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[1172536]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1173688]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1174840]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[1178296]=Pssp;
	Mxe_sp_s[360377]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[361529]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[362681]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[363833]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[364985]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[366137]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[367289]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[368441]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1172537]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1173689]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1179449]=Pssp;
	Mxe_sp_s[362682]=-Pssp;
	Mxe_sp_s[363835]=-Pssp;
	Mxe_sp_s[364988]=-Pssp;
	Mxe_sp_s[368445]=-Pssp;
	Mxe_sp_s[367294]=-Pssp;
	Mxe_sp_s[366143]=-Pssp;
	Mxe_sp_s[377664]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[1180608]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[1181760]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[1189824]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1190976]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[1192128]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[371905]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[373057]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[374209]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1181761]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1182913]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1186369]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[1189825]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[1190977]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1192129]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[371906]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[373058]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1181762]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1182914]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1186370]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[1188674]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1189826]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[1190978]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1192130]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[369603]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[370755]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[371907]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[373059]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[374211]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[375363]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[376515]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[377667]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1186371]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[1189827]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1190979]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[1192131]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[369604]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[370756]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[371908]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[373060]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[374212]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[375364]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[376516]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[377668]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[1187524]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[1189828]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[1190980]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[1192132]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[369605]=iiota*Pssp*zbar;
	Mxe_sp_s[373061]=iiota*Pssp*zbar;
	Mxe_sp_s[1187525]=-Pssp;
	Mxe_sp_s[1181766]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[1188678]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[1190982]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1192134]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[370759]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[371911]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[373063]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[374215]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[376519]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[1180615]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[1181767]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[1182919]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[1184071]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[1186375]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1188679]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[1190983]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[1192135]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[369608]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[373064]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[1184072]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[1190984]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[1192136]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[369609]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[370761]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[373065]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[374217]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1181769]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1182921]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1186377]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1187529]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1188681]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1190985]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1192137]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1190986]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1192138]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[370763]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[375371]=Pssp;
	Mxe_sp_s[1186379]=-Pssp;
	Mxe_sp_s[1190987]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[1192139]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[369612]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[1185228]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[371917]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[373069]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[374221]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[1181773]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1182925]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[1190989]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1192141]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1193293]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[370766]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[373070]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1190990]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1192142]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1193294]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1194446]=Pssp;
	Mxe_sp_s[370767]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[373071]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1190991]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1192143]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1193295]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1195599]=Pssp;
	Mxe_sp_s[376528]=ebar*Pssp;
	Mxe_sp_s[1180624]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[1184080]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[1190992]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1192144]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1193296]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[1196752]=Pssp;
	Mxe_sp_s[369617]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[370769]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[371921]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[373073]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[374225]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[375377]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[376529]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[377681]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1190993]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1192145]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1197905]=Pssp;
	Mxe_sp_s[371922]=-Pssp;
	Mxe_sp_s[373075]=-Pssp;
	Mxe_sp_s[374228]=-Pssp;
	Mxe_sp_s[377685]=-Pssp;
	Mxe_sp_s[376534]=-Pssp;
	Mxe_sp_s[375383]=-Pssp;
	Mxe_sp_s[386904]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[1199064]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[1200216]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[1208280]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1209432]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[1210584]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[381145]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[382297]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[383449]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1200217]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1201369]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1204825]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[1208281]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[1209433]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1210585]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[381146]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[382298]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1200218]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1201370]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1204826]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[1207130]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1208282]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[1209434]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1210586]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[378843]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[379995]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[381147]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[382299]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[383451]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[384603]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[385755]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[386907]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1204827]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[1208283]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1209435]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[1210587]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[378844]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[379996]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[381148]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[382300]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[383452]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[384604]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[385756]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[386908]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[1205980]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[1208284]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[1209436]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[1210588]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[378845]=iiota*Pssp*zbar;
	Mxe_sp_s[382301]=iiota*Pssp*zbar;
	Mxe_sp_s[1205981]=-Pssp;
	Mxe_sp_s[1200222]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[1207134]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[1209438]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1210590]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[379999]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[381151]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[382303]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[383455]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[385759]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[1199071]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[1200223]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[1201375]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[1202527]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[1204831]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1207135]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[1209439]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[1210591]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[378848]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[382304]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[1202528]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[1209440]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[1210592]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[378849]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[380001]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[382305]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[383457]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1200225]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1201377]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1204833]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1205985]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1207137]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1209441]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1210593]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1209442]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1210594]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[380003]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[384611]=Pssp;
	Mxe_sp_s[1204835]=-Pssp;
	Mxe_sp_s[1209443]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[1210595]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[378852]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[1203684]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[381157]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[382309]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[383461]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[1200229]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1201381]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[1209445]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1210597]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1211749]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[380006]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[382310]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1209446]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1210598]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1211750]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1212902]=Pssp;
	Mxe_sp_s[380007]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[382311]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1209447]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1210599]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1211751]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1214055]=Pssp;
	Mxe_sp_s[385768]=ebar*Pssp;
	Mxe_sp_s[1199080]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[1202536]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[1209448]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1210600]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1211752]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[1215208]=Pssp;
	Mxe_sp_s[378857]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[380009]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[381161]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[382313]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[383465]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[384617]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[385769]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[386921]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1209449]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1210601]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1216361]=Pssp;
	Mxe_sp_s[381162]=-Pssp;
	Mxe_sp_s[382315]=-Pssp;
	Mxe_sp_s[383468]=-Pssp;
	Mxe_sp_s[386925]=-Pssp;
	Mxe_sp_s[385774]=-Pssp;
	Mxe_sp_s[384623]=-Pssp;
	Mxe_sp_s[396144]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[1217520]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[1218672]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[1226736]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1227888]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[1229040]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[390385]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[391537]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[392689]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1218673]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1219825]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1223281]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[1226737]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[1227889]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1229041]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[390386]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[391538]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1218674]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1219826]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1223282]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[1225586]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1226738]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[1227890]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1229042]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[388083]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[389235]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[390387]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[391539]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[392691]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[393843]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[394995]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[396147]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1223283]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[1226739]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1227891]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[1229043]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[388084]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[389236]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[390388]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[391540]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[392692]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[393844]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[394996]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[396148]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[1224436]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[1226740]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[1227892]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[1229044]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[388085]=iiota*Pssp*zbar;
	Mxe_sp_s[391541]=iiota*Pssp*zbar;
	Mxe_sp_s[1224437]=-Pssp;
	Mxe_sp_s[1218678]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[1225590]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[1227894]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1229046]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[389239]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[390391]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[391543]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[392695]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[394999]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[1217527]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[1218679]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[1219831]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[1220983]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[1223287]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1225591]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[1227895]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[1229047]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[388088]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[391544]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[1220984]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[1227896]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[1229048]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[388089]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[389241]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[391545]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[392697]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1218681]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1219833]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1223289]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1224441]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1225593]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1227897]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1229049]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1227898]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1229050]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[389243]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[393851]=Pssp;
	Mxe_sp_s[1223291]=-Pssp;
	Mxe_sp_s[1227899]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[1229051]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[388092]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[1222140]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[390397]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[391549]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[392701]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[1218685]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1219837]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[1227901]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1229053]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1230205]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[389246]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[391550]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1227902]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1229054]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1230206]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1231358]=Pssp;
	Mxe_sp_s[389247]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[391551]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1227903]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1229055]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1230207]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1232511]=Pssp;
	Mxe_sp_s[395008]=ebar*Pssp;
	Mxe_sp_s[1217536]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[1220992]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[1227904]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1229056]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1230208]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[1233664]=Pssp;
	Mxe_sp_s[388097]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[389249]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[390401]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[391553]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[392705]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[393857]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[395009]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[396161]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1227905]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1229057]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1234817]=Pssp;
	Mxe_sp_s[390402]=-Pssp;
	Mxe_sp_s[391555]=-Pssp;
	Mxe_sp_s[392708]=-Pssp;
	Mxe_sp_s[396165]=-Pssp;
	Mxe_sp_s[395014]=-Pssp;
	Mxe_sp_s[393863]=-Pssp;
	Mxe_sp_s[405384]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[1235976]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[1237128]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[1245192]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1246344]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[1247496]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[399625]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[400777]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[401929]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1237129]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1238281]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1241737]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[1245193]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[1246345]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1247497]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[399626]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[400778]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1237130]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1238282]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1241738]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[1244042]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1245194]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[1246346]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1247498]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[397323]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[398475]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[399627]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[400779]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[401931]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[403083]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[404235]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[405387]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1241739]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[1245195]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1246347]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[1247499]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[397324]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[398476]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[399628]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[400780]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[401932]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[403084]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[404236]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[405388]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[1242892]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[1245196]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[1246348]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[1247500]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[397325]=iiota*Pssp*zbar;
	Mxe_sp_s[400781]=iiota*Pssp*zbar;
	Mxe_sp_s[1242893]=-Pssp;
	Mxe_sp_s[1237134]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[1244046]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[1246350]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1247502]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[398479]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[399631]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[400783]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[401935]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[404239]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[1235983]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[1237135]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[1238287]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[1239439]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[1241743]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1244047]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[1246351]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[1247503]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[397328]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[400784]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[1239440]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[1246352]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[1247504]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[397329]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[398481]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[400785]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[401937]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1237137]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1238289]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1241745]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1242897]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1244049]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1246353]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1247505]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1246354]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1247506]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[398483]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[403091]=Pssp;
	Mxe_sp_s[1241747]=-Pssp;
	Mxe_sp_s[1246355]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[1247507]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[397332]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[1240596]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[399637]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[400789]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[401941]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[1237141]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1238293]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[1246357]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1247509]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1248661]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[398486]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[400790]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1246358]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1247510]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1248662]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1249814]=Pssp;
	Mxe_sp_s[398487]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[400791]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1246359]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1247511]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1248663]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1250967]=Pssp;
	Mxe_sp_s[404248]=ebar*Pssp;
	Mxe_sp_s[1235992]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[1239448]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[1246360]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1247512]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1248664]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[1252120]=Pssp;
	Mxe_sp_s[397337]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[398489]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[399641]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[400793]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[401945]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[403097]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[404249]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[405401]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1246361]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1247513]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1253273]=Pssp;
	Mxe_sp_s[399642]=-Pssp;
	Mxe_sp_s[400795]=-Pssp;
	Mxe_sp_s[401948]=-Pssp;
	Mxe_sp_s[405405]=-Pssp;
	Mxe_sp_s[404254]=-Pssp;
	Mxe_sp_s[403103]=-Pssp;
	Mxe_sp_s[414624]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[1254432]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[1255584]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[1263648]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1264800]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[1265952]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[408865]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[410017]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[411169]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1255585]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1256737]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1260193]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[1263649]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[1264801]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1265953]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[408866]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[410018]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1255586]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1256738]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1260194]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[1262498]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1263650]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[1264802]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1265954]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[406563]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[407715]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[408867]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[410019]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[411171]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[412323]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[413475]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[414627]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1260195]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[1263651]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1264803]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[1265955]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[406564]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[407716]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[408868]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[410020]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[411172]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[412324]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[413476]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[414628]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[1261348]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[1263652]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[1264804]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[1265956]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[406565]=iiota*Pssp*zbar;
	Mxe_sp_s[410021]=iiota*Pssp*zbar;
	Mxe_sp_s[1261349]=-Pssp;
	Mxe_sp_s[1255590]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[1262502]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[1264806]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1265958]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[407719]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[408871]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[410023]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[411175]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[413479]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[1254439]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[1255591]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[1256743]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[1257895]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[1260199]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1262503]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[1264807]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[1265959]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[406568]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[410024]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[1257896]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[1264808]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[1265960]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[406569]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[407721]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[410025]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[411177]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1255593]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1256745]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1260201]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1261353]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1262505]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1264809]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1265961]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1264810]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1265962]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[407723]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[412331]=Pssp;
	Mxe_sp_s[1260203]=-Pssp;
	Mxe_sp_s[1264811]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[1265963]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[406572]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[1259052]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[408877]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[410029]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[411181]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[1255597]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1256749]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[1264813]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1265965]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1267117]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[407726]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[410030]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1264814]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1265966]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1267118]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1268270]=Pssp;
	Mxe_sp_s[407727]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[410031]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1264815]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1265967]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1267119]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1269423]=Pssp;
	Mxe_sp_s[413488]=ebar*Pssp;
	Mxe_sp_s[1254448]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[1257904]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[1264816]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1265968]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1267120]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[1270576]=Pssp;
	Mxe_sp_s[406577]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[407729]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[408881]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[410033]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[411185]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[412337]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[413489]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[414641]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1264817]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1265969]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1271729]=Pssp;
	Mxe_sp_s[408882]=-Pssp;
	Mxe_sp_s[410035]=-Pssp;
	Mxe_sp_s[411188]=-Pssp;
	Mxe_sp_s[414645]=-Pssp;
	Mxe_sp_s[413494]=-Pssp;
	Mxe_sp_s[412343]=-Pssp;
	Mxe_sp_s[423864]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[1272888]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[1274040]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[1282104]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1283256]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[1284408]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[418105]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[419257]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[420409]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1274041]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1275193]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1278649]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[1282105]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[1283257]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1284409]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[418106]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[419258]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1274042]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1275194]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1278650]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[1280954]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1282106]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[1283258]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1284410]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[415803]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[416955]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[418107]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[419259]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[420411]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[421563]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[422715]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[423867]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1278651]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[1282107]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1283259]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[1284411]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[415804]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[416956]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[418108]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[419260]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[420412]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[421564]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[422716]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[423868]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[1279804]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[1282108]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[1283260]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[1284412]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[415805]=iiota*Pssp*zbar;
	Mxe_sp_s[419261]=iiota*Pssp*zbar;
	Mxe_sp_s[1279805]=-Pssp;
	Mxe_sp_s[1274046]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[1280958]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[1283262]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1284414]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[416959]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[418111]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[419263]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[420415]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[422719]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[1272895]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[1274047]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[1275199]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[1276351]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[1278655]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1280959]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[1283263]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[1284415]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[415808]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[419264]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[1276352]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[1283264]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[1284416]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[415809]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[416961]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[419265]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[420417]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1274049]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1275201]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1278657]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1279809]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1280961]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1283265]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1284417]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1283266]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1284418]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[416963]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[421571]=Pssp;
	Mxe_sp_s[1278659]=-Pssp;
	Mxe_sp_s[1283267]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[1284419]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[415812]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[1277508]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[418117]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[419269]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[420421]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[1274053]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1275205]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[1283269]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1284421]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1285573]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[416966]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[419270]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1283270]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1284422]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1285574]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1286726]=Pssp;
	Mxe_sp_s[416967]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[419271]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1283271]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1284423]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1285575]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1287879]=Pssp;
	Mxe_sp_s[422728]=ebar*Pssp;
	Mxe_sp_s[1272904]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[1276360]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[1283272]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1284424]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1285576]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[1289032]=Pssp;
	Mxe_sp_s[415817]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[416969]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[418121]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[419273]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[420425]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[421577]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[422729]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[423881]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1283273]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1284425]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1290185]=Pssp;
	Mxe_sp_s[418122]=-Pssp;
	Mxe_sp_s[419275]=-Pssp;
	Mxe_sp_s[420428]=-Pssp;
	Mxe_sp_s[423885]=-Pssp;
	Mxe_sp_s[422734]=-Pssp;
	Mxe_sp_s[421583]=-Pssp;
	Mxe_sp_s[433104]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[1291344]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[1292496]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[1300560]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1301712]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[1302864]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[427345]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[428497]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[429649]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1292497]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1293649]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1297105]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[1300561]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[1301713]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1302865]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[427346]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[428498]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1292498]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1293650]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1297106]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[1299410]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1300562]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[1301714]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1302866]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[425043]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[426195]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[427347]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[428499]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[429651]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[430803]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[431955]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[433107]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1297107]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[1300563]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1301715]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[1302867]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[425044]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[426196]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[427348]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[428500]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[429652]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[430804]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[431956]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[433108]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[1298260]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[1300564]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[1301716]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[1302868]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[425045]=iiota*Pssp*zbar;
	Mxe_sp_s[428501]=iiota*Pssp*zbar;
	Mxe_sp_s[1298261]=-Pssp;
	Mxe_sp_s[1292502]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[1299414]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[1301718]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1302870]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[426199]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[427351]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[428503]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[429655]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[431959]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[1291351]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[1292503]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[1293655]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[1294807]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[1297111]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1299415]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[1301719]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[1302871]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[425048]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[428504]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[1294808]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[1301720]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[1302872]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[425049]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[426201]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[428505]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[429657]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1292505]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1293657]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1297113]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1298265]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1299417]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1301721]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1302873]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1301722]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1302874]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[426203]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[430811]=Pssp;
	Mxe_sp_s[1297115]=-Pssp;
	Mxe_sp_s[1301723]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[1302875]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[425052]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[1295964]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[427357]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[428509]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[429661]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[1292509]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1293661]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[1301725]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1302877]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1304029]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[426206]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[428510]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1301726]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1302878]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1304030]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1305182]=Pssp;
	Mxe_sp_s[426207]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[428511]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1301727]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1302879]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1304031]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1306335]=Pssp;
	Mxe_sp_s[431968]=ebar*Pssp;
	Mxe_sp_s[1291360]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[1294816]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[1301728]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1302880]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1304032]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[1307488]=Pssp;
	Mxe_sp_s[425057]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[426209]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[427361]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[428513]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[429665]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[430817]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[431969]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[433121]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1301729]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1302881]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1308641]=Pssp;
	Mxe_sp_s[427362]=-Pssp;
	Mxe_sp_s[428515]=-Pssp;
	Mxe_sp_s[429668]=-Pssp;
	Mxe_sp_s[433125]=-Pssp;
	Mxe_sp_s[431974]=-Pssp;
	Mxe_sp_s[430823]=-Pssp;
	Mxe_sp_s[442344]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxe_sp_s[1309800]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxe_sp_s[1310952]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxe_sp_s[1319016]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1320168]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[1321320]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxe_sp_s[436585]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[437737]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[438889]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1310953]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1312105]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1315561]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxe_sp_s[1319017]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxe_sp_s[1320169]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1321321]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[436586]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[437738]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1310954]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1312106]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[1315562]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxe_sp_s[1317866]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1319018]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxe_sp_s[1320170]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[1321322]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxe_sp_s[434283]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[435435]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[436587]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[437739]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxe_sp_s[438891]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[440043]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[441195]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[442347]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxe_sp_s[1315563]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxe_sp_s[1319019]=-(pow(E,yss[8])*Pssp);
	Mxe_sp_s[1320171]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxe_sp_s[1321323]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxe_sp_s[434284]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxe_sp_s[435436]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxe_sp_s[436588]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxe_sp_s[437740]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxe_sp_s[438892]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxe_sp_s[440044]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxe_sp_s[441196]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxe_sp_s[442348]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxe_sp_s[1316716]=-(kkappa*Pssp*yss[9]);
	Mxe_sp_s[1319020]=pow(E,yss[8])*Pssp;
	Mxe_sp_s[1320172]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxe_sp_s[1321324]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxe_sp_s[434285]=iiota*Pssp*zbar;
	Mxe_sp_s[437741]=iiota*Pssp*zbar;
	Mxe_sp_s[1316717]=-Pssp;
	Mxe_sp_s[1310958]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxe_sp_s[1317870]=-(pow(E,yss[7])*Pssp);
	Mxe_sp_s[1320174]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[1321326]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxe_sp_s[435439]=-((Pssp*zbar)/(1 + yss[5]));
	Mxe_sp_s[436591]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxe_sp_s[437743]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxe_sp_s[438895]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxe_sp_s[441199]=-(pow(E,yss[11])*ebar*Pssp);
	Mxe_sp_s[1309807]=-(pow(E,yss[0])*Pssp);
	Mxe_sp_s[1310959]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxe_sp_s[1312111]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxe_sp_s[1313263]=-(pow(E,yss[3])*Pssp);
	Mxe_sp_s[1315567]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1317871]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxe_sp_s[1320175]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[1321327]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxe_sp_s[434288]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[437744]=-(pow(E,xss[0])*Pssp*zbar);
	Mxe_sp_s[1313264]=pow(E,yss[3])*Pssp;
	Mxe_sp_s[1320176]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[1321328]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxe_sp_s[434289]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[435441]=(Pssp*zbar)/(1 + yss[5]);
	Mxe_sp_s[437745]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxe_sp_s[438897]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1310961]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1312113]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1315569]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxe_sp_s[1316721]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxe_sp_s[1317873]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxe_sp_s[1320177]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1321329]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxe_sp_s[1320178]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[1321330]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxe_sp_s[435443]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxe_sp_s[440051]=Pssp;
	Mxe_sp_s[1315571]=-Pssp;
	Mxe_sp_s[1320179]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[1321331]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxe_sp_s[434292]=pow(E,xss[0])*Pssp;
	Mxe_sp_s[1314420]=-(pow(E,xss[0])*Pssp);
	Mxe_sp_s[436597]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[437749]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[438901]=pow(E,yss[2])*pbar*Pssp;
	Mxe_sp_s[1310965]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxe_sp_s[1312117]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxe_sp_s[1320181]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1321333]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxe_sp_s[1322485]=pow(E,yss[11])*Pssp;
	Mxe_sp_s[435446]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[437750]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1320182]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1321334]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxe_sp_s[1322486]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1323638]=Pssp;
	Mxe_sp_s[435447]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxe_sp_s[437751]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxe_sp_s[1320183]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1321335]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxe_sp_s[1322487]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxe_sp_s[1324791]=Pssp;
	Mxe_sp_s[441208]=ebar*Pssp;
	Mxe_sp_s[1309816]=pow(E,yss[0] - yss[11])*Pssp;
	Mxe_sp_s[1313272]=pow(E,yss[3] - yss[11])*Pssp;
	Mxe_sp_s[1320184]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1321336]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxe_sp_s[1322488]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxe_sp_s[1325944]=Pssp;
	Mxe_sp_s[434297]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[435449]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[436601]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[437753]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxe_sp_s[438905]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[440057]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[441209]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[442361]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1320185]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1321337]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxe_sp_s[1327097]=Pssp;
	Mxe_sp_s[436602]=-Pssp;
	Mxe_sp_s[437755]=-Pssp;
	Mxe_sp_s[438908]=-Pssp;
	Mxe_sp_s[442365]=-Pssp;
	Mxe_sp_s[441214]=-Pssp;
	Mxe_sp_s[440063]=-Pssp;
	Nxe_sp_s[0]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[0]*Gs[128]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[1]*Gs[129] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129]) - pow(E,yss[8])*Pssp*Gs[8]*Gs[136] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])*Hs[7] + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])) - pow(E,yss[8])*Gs[8] + Hs[7]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*Hs[71] + (Pssp*Hs[7]*Hs[71])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[128] - pow(pow(E,yss[1]),oomega)*Gs[129])) - pow(E,yss[8])*Gs[136] + Hs[71]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxe_sp_s[1]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]) - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[129] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[129] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[130] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[130] - (pbar*pphi*Pssp*Gs[9]*Gs[133])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[5]*Gs[137])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[2] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[2] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[3] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[3] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[66] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[66] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[66] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[66] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[66] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[67] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[67] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[67] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[67] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[67] + (pbar*pphi*Pssp*Gs[9]*Gs[136]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[8]*Gs[137]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[8]*Gs[133]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[5]*Gs[136]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[8]*Gs[136]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[4]*Hs[68]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[68]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[4]*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[3] - pbar*Hs[4]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[129]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[130] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[66] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[67] - pbar*Hs[68]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])))/pow(E,yss[8]));
	Nxe_sp_s[2]=(-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[129] - pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[1]*Gs[129] + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[129] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[129] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[130] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[130] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[130] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[9]*Gs[133] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[137] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[2] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[129]*Hs[3] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[130]*Hs[3] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[66] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[66] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[66] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[67] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[67] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[67] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[67] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[67] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[9]*Gs[136]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[137]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[133]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[136]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[136]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[7]*Gs[135]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[135]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[7]*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[7])*pphi*Gs[7]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9]))) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[129]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[129] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[130] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[66] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[67] - pow(E,yss[7])*pphi*Gs[135]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[133]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[137] - Gs[136]*yss[9])));
	Nxe_sp_s[3]=-(pow(E,yss[8])*Pssp*Gs[8]*Gs[136]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[133]*Hs[3])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[133]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[5]*Hs[67])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[5]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[3]*Hs[67]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[67]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[0]*(G2sp[8]*Hs[64] + G2sp[24]*Hs[65] + G2sp[40]*Hs[66] + G2sp[56]*Hs[67] + G2sp[72]*Hs[68] + G2sp[88]*Hs[69] + G2sp[104]*Hs[70] + G2sp[120]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[1]*(G2sp[24]*Hs[64] + G2sp[264]*Hs[65] + G2sp[280]*Hs[66] + G2sp[296]*Hs[67] + G2sp[312]*Hs[68] + G2sp[328]*Hs[69] + G2sp[344]*Hs[70] + G2sp[360]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[2]*(G2sp[40]*Hs[64] + G2sp[280]*Hs[65] + G2sp[520]*Hs[66] + G2sp[536]*Hs[67] + G2sp[552]*Hs[68] + G2sp[568]*Hs[69] + G2sp[584]*Hs[70] + G2sp[600]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[3]*(G2sp[56]*Hs[64] + G2sp[296]*Hs[65] + G2sp[536]*Hs[66] + G2sp[776]*Hs[67] + G2sp[792]*Hs[68] + G2sp[808]*Hs[69] + G2sp[824]*Hs[70] + G2sp[840]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[4]*(G2sp[72]*Hs[64] + G2sp[312]*Hs[65] + G2sp[552]*Hs[66] + G2sp[792]*Hs[67] + G2sp[1032]*Hs[68] + G2sp[1048]*Hs[69] + G2sp[1064]*Hs[70] + G2sp[1080]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[5]*(G2sp[88]*Hs[64] + G2sp[328]*Hs[65] + G2sp[568]*Hs[66] + G2sp[808]*Hs[67] + G2sp[1048]*Hs[68] + G2sp[1288]*Hs[69] + G2sp[1304]*Hs[70] + G2sp[1320]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[6]*(G2sp[104]*Hs[64] + G2sp[344]*Hs[65] + G2sp[584]*Hs[66] + G2sp[824]*Hs[67] + G2sp[1064]*Hs[68] + G2sp[1304]*Hs[69] + G2sp[1544]*Hs[70] + G2sp[1560]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Hs[7]*(G2sp[120]*Hs[64] + G2sp[360]*Hs[65] + G2sp[600]*Hs[66] + G2sp[840]*Hs[67] + G2sp[1080]*Hs[68] + G2sp[1320]*Hs[69] + G2sp[1560]*Hs[70] + G2sp[1800]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[3]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*((bbeta*pow(E,yss[8])*Gs[5])/pow(zbar,rrho) - pow(E,yss[8])*Gs[8] + Gs[9] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[3]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*((bbeta*pow(E,yss[8])*Gs[133])/pow(zbar,rrho) - pow(E,yss[8])*Gs[136] + Gs[137] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[67]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71])*(1 + yss[5]))/pow(zbar,rrho));
	Nxe_sp_s[4]=-(kkappa*Pssp*Gs[9]*Gs[134]) + pow(E,yss[8])*Pssp*Gs[8]*Gs[136] - kkappa*Pssp*Gs[6]*Gs[137] + pow(E,yss[8])*iiota*Pssp*zbar*Gs[136]*(-1 + Hs[0] + Hs[3]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[64] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[64] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*Hs[64] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*Hs[64] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[64] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[64] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*Hs[64] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[0]*Hs[66] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[2]*Hs[66] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*Hs[66] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[66] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[66] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[0]*Hs[67] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[2]*Hs[67] - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[3]*Hs[67] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[67])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[67] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[67] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[67])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]))*Hs[67])/pow(zbar,rrho) - pow(E,yss[8])*iiota*Pssp*zbar*(Hs[64] + Hs[67]) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[8]*(Hs[64] + Hs[67]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[64] + Hs[67]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(G2sp[1]*Hs[64] + G2sp[17]*Hs[65] + G2sp[33]*Hs[66] + G2sp[49]*Hs[67] + G2sp[65]*Hs[68] + G2sp[81]*Hs[69] + G2sp[97]*Hs[70] + G2sp[113]*Hs[71]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(G2sp[2]*Hs[64] + G2sp[18]*Hs[65] + G2sp[34]*Hs[66] + G2sp[50]*Hs[67] + G2sp[66]*Hs[68] + G2sp[82]*Hs[69] + G2sp[98]*Hs[70] + G2sp[114]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*(G2sp[4]*Hs[64] + G2sp[20]*Hs[65] + G2sp[36]*Hs[66] + G2sp[52]*Hs[67] + G2sp[68]*Hs[68] + G2sp[84]*Hs[69] + G2sp[100]*Hs[70] + G2sp[116]*Hs[71]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[0]*(G2sp[8]*Hs[64] + G2sp[24]*Hs[65] + G2sp[40]*Hs[66] + G2sp[56]*Hs[67] + G2sp[72]*Hs[68] + G2sp[88]*Hs[69] + G2sp[104]*Hs[70] + G2sp[120]*Hs[71]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*(G2sp[17]*Hs[64] + G2sp[257]*Hs[65] + G2sp[273]*Hs[66] + G2sp[289]*Hs[67] + G2sp[305]*Hs[68] + G2sp[321]*Hs[69] + G2sp[337]*Hs[70] + G2sp[353]*Hs[71]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*(G2sp[18]*Hs[64] + G2sp[258]*Hs[65] + G2sp[274]*Hs[66] + G2sp[290]*Hs[67] + G2sp[306]*Hs[68] + G2sp[322]*Hs[69] + G2sp[338]*Hs[70] + G2sp[354]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[1]*(G2sp[20]*Hs[64] + G2sp[260]*Hs[65] + G2sp[276]*Hs[66] + G2sp[292]*Hs[67] + G2sp[308]*Hs[68] + G2sp[324]*Hs[69] + G2sp[340]*Hs[70] + G2sp[356]*Hs[71]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[1]*(G2sp[24]*Hs[64] + G2sp[264]*Hs[65] + G2sp[280]*Hs[66] + G2sp[296]*Hs[67] + G2sp[312]*Hs[68] + G2sp[328]*Hs[69] + G2sp[344]*Hs[70] + G2sp[360]*Hs[71]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*(G2sp[33]*Hs[64] + G2sp[273]*Hs[65] + G2sp[513]*Hs[66] + G2sp[529]*Hs[67] + G2sp[545]*Hs[68] + G2sp[561]*Hs[69] + G2sp[577]*Hs[70] + G2sp[593]*Hs[71]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*(G2sp[34]*Hs[64] + G2sp[274]*Hs[65] + G2sp[514]*Hs[66] + G2sp[530]*Hs[67] + G2sp[546]*Hs[68] + G2sp[562]*Hs[69] + G2sp[578]*Hs[70] + G2sp[594]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[2]*(G2sp[36]*Hs[64] + G2sp[276]*Hs[65] + G2sp[516]*Hs[66] + G2sp[532]*Hs[67] + G2sp[548]*Hs[68] + G2sp[564]*Hs[69] + G2sp[580]*Hs[70] + G2sp[596]*Hs[71]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[2]*(G2sp[40]*Hs[64] + G2sp[280]*Hs[65] + G2sp[520]*Hs[66] + G2sp[536]*Hs[67] + G2sp[552]*Hs[68] + G2sp[568]*Hs[69] + G2sp[584]*Hs[70] + G2sp[600]*Hs[71]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*(G2sp[49]*Hs[64] + G2sp[289]*Hs[65] + G2sp[529]*Hs[66] + G2sp[769]*Hs[67] + G2sp[785]*Hs[68] + G2sp[801]*Hs[69] + G2sp[817]*Hs[70] + G2sp[833]*Hs[71]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*(G2sp[50]*Hs[64] + G2sp[290]*Hs[65] + G2sp[530]*Hs[66] + G2sp[770]*Hs[67] + G2sp[786]*Hs[68] + G2sp[802]*Hs[69] + G2sp[818]*Hs[70] + G2sp[834]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[3]*(G2sp[52]*Hs[64] + G2sp[292]*Hs[65] + G2sp[532]*Hs[66] + G2sp[772]*Hs[67] + G2sp[788]*Hs[68] + G2sp[804]*Hs[69] + G2sp[820]*Hs[70] + G2sp[836]*Hs[71]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*(G2sp[56]*Hs[64] + G2sp[296]*Hs[65] + G2sp[536]*Hs[66] + G2sp[776]*Hs[67] + G2sp[792]*Hs[68] + G2sp[808]*Hs[69] + G2sp[824]*Hs[70] + G2sp[840]*Hs[71]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*(G2sp[65]*Hs[64] + G2sp[305]*Hs[65] + G2sp[545]*Hs[66] + G2sp[785]*Hs[67] + G2sp[1025]*Hs[68] + G2sp[1041]*Hs[69] + G2sp[1057]*Hs[70] + G2sp[1073]*Hs[71]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*(G2sp[66]*Hs[64] + G2sp[306]*Hs[65] + G2sp[546]*Hs[66] + G2sp[786]*Hs[67] + G2sp[1026]*Hs[68] + G2sp[1042]*Hs[69] + G2sp[1058]*Hs[70] + G2sp[1074]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[4]*(G2sp[68]*Hs[64] + G2sp[308]*Hs[65] + G2sp[548]*Hs[66] + G2sp[788]*Hs[67] + G2sp[1028]*Hs[68] + G2sp[1044]*Hs[69] + G2sp[1060]*Hs[70] + G2sp[1076]*Hs[71]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[4]*(G2sp[72]*Hs[64] + G2sp[312]*Hs[65] + G2sp[552]*Hs[66] + G2sp[792]*Hs[67] + G2sp[1032]*Hs[68] + G2sp[1048]*Hs[69] + G2sp[1064]*Hs[70] + G2sp[1080]*Hs[71]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*(G2sp[81]*Hs[64] + G2sp[321]*Hs[65] + G2sp[561]*Hs[66] + G2sp[801]*Hs[67] + G2sp[1041]*Hs[68] + G2sp[1281]*Hs[69] + G2sp[1297]*Hs[70] + G2sp[1313]*Hs[71]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*(G2sp[82]*Hs[64] + G2sp[322]*Hs[65] + G2sp[562]*Hs[66] + G2sp[802]*Hs[67] + G2sp[1042]*Hs[68] + G2sp[1282]*Hs[69] + G2sp[1298]*Hs[70] + G2sp[1314]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[5]*(G2sp[84]*Hs[64] + G2sp[324]*Hs[65] + G2sp[564]*Hs[66] + G2sp[804]*Hs[67] + G2sp[1044]*Hs[68] + G2sp[1284]*Hs[69] + G2sp[1300]*Hs[70] + G2sp[1316]*Hs[71]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[5]*(G2sp[88]*Hs[64] + G2sp[328]*Hs[65] + G2sp[568]*Hs[66] + G2sp[808]*Hs[67] + G2sp[1048]*Hs[68] + G2sp[1288]*Hs[69] + G2sp[1304]*Hs[70] + G2sp[1320]*Hs[71]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[6]*(G2sp[97]*Hs[64] + G2sp[337]*Hs[65] + G2sp[577]*Hs[66] + G2sp[817]*Hs[67] + G2sp[1057]*Hs[68] + G2sp[1297]*Hs[69] + G2sp[1537]*Hs[70] + G2sp[1553]*Hs[71]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[6]*(G2sp[98]*Hs[64] + G2sp[338]*Hs[65] + G2sp[578]*Hs[66] + G2sp[818]*Hs[67] + G2sp[1058]*Hs[68] + G2sp[1298]*Hs[69] + G2sp[1538]*Hs[70] + G2sp[1554]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[6]*(G2sp[100]*Hs[64] + G2sp[340]*Hs[65] + G2sp[580]*Hs[66] + G2sp[820]*Hs[67] + G2sp[1060]*Hs[68] + G2sp[1300]*Hs[69] + G2sp[1540]*Hs[70] + G2sp[1556]*Hs[71]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[6]*(G2sp[104]*Hs[64] + G2sp[344]*Hs[65] + G2sp[584]*Hs[66] + G2sp[824]*Hs[67] + G2sp[1064]*Hs[68] + G2sp[1304]*Hs[69] + G2sp[1544]*Hs[70] + G2sp[1560]*Hs[71]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[7]*(G2sp[113]*Hs[64] + G2sp[353]*Hs[65] + G2sp[593]*Hs[66] + G2sp[833]*Hs[67] + G2sp[1073]*Hs[68] + G2sp[1313]*Hs[69] + G2sp[1553]*Hs[70] + G2sp[1793]*Hs[71]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[7]*(G2sp[114]*Hs[64] + G2sp[354]*Hs[65] + G2sp[594]*Hs[66] + G2sp[834]*Hs[67] + G2sp[1074]*Hs[68] + G2sp[1314]*Hs[69] + G2sp[1554]*Hs[70] + G2sp[1794]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[7]*(G2sp[116]*Hs[64] + G2sp[356]*Hs[65] + G2sp[596]*Hs[66] + G2sp[836]*Hs[67] + G2sp[1076]*Hs[68] + G2sp[1316]*Hs[69] + G2sp[1556]*Hs[70] + G2sp[1796]*Hs[71]) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[7]*(G2sp[120]*Hs[64] + G2sp[360]*Hs[65] + G2sp[600]*Hs[66] + G2sp[840]*Hs[67] + G2sp[1080]*Hs[68] + G2sp[1320]*Hs[69] + G2sp[1560]*Hs[70] + G2sp[1800]*Hs[71]))/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*(Gsp[4]*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[3]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])))/pow(zbar,rrho) - kkappa*Pssp*Gs[6]*Gs[134]*yss[9] + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(pow(E,yss[8])*Gs[8] - kkappa*Gs[9] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(-1 + Hs[0] + Hs[3]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])))/pow(zbar,rrho) - kkappa*Gs[6]*yss[9]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[8])*Gs[136] - kkappa*Gs[137] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[67])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[64] + Hs[67]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[64] + Gsp[24]*Hs[65] + Gsp[40]*Hs[66] + Gsp[56]*Hs[67] + Gsp[72]*Hs[68] + Gsp[88]*Hs[69] + Gsp[104]*Hs[70] + Gsp[120]*Hs[71]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[64] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[67] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[64] + Gsp[17]*Hs[65] + Gsp[33]*Hs[66] + Gsp[49]*Hs[67] + Gsp[65]*Hs[68] + Gsp[81]*Hs[69] + Gsp[97]*Hs[70] + Gsp[113]*Hs[71]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[64] + Gsp[18]*Hs[65] + Gsp[34]*Hs[66] + Gsp[50]*Hs[67] + Gsp[66]*Hs[68] + Gsp[82]*Hs[69] + Gsp[98]*Hs[70] + Gsp[114]*Hs[71]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[64] + Gsp[20]*Hs[65] + Gsp[36]*Hs[66] + (rrhoz + Gsp[52])*Hs[67] + Gsp[68]*Hs[68] + Gsp[84]*Hs[69] + Gsp[100]*Hs[70] + Gsp[116]*Hs[71])))/pow(zbar,rrho) - kkappa*Gs[134]*yss[9]);
	Nxe_sp_s[5]=-(Pssp*Gs[6]*Gs[134]) + (dP2ssp*Gs[137] + dP1ssp*Gs[138])*(-Gs[6] + iiota*zbar*Hs[0] + iiota*zbar*(-1 + Hs[3])) - iiota*Pssp*zbar*(Hs[64] + Hs[67]) + iiota*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[64] + Hs[67]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[134] + iiota*zbar*(Hs[64] + Hs[67]));
	Nxe_sp_s[6]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[1]*Gs[129] - pow(E,yss[7])*Pssp*Gs[7]*Gs[135] + (dP2ssp*Gs[9] 